// --------------------------------------------------------------------
// CFurserSrMacr.cpp
// Whatis:  Furser Server Details class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#include	"CFurserSrMacr.h"
#include	"CError.hxx"

// --------------------------------------------------------------------
CFurserSrMacr::CFurserSrMacr	() {
	CFurserSrMacr::Cleanup();
}

// --------------------------------------------------------------------
CFurserSrMacr::~CFurserSrMacr	() {
	CFurserSrMacr::Free();
}

// --------------------------------------------------------------------
CFurserSrMacr::CFurserSrMacr				( const CFurserSrMacr & aC ) {
	CFurserSrMacr::Cleanup();
	*this = aC;
}

// --------------------------------------------------------------------
CFurserSrMacr & CFurserSrMacr::operator =	( const CFurserSrMacr & aC ) {
	CFurserSrMacr::Free();
	CFurserSrMacr::MacroName	( aC.MacroName() );
	CFurserSrMacr::MacroValue	( aC.MacroValue() );
	return *this;
}

// --------------------------------------------------------------------
bool CFurserSrMacr::operator == ( const CFurserSrMacr & aC ) const {
	return	*this == aC.MacroName();
}

// --------------------------------------------------------------------
bool CFurserSrMacr::operator != ( const CFurserSrMacr & aC ) const {
	return	*this != aC.MacroName();
}

// --------------------------------------------------------------------
bool CFurserSrMacr::operator == ( const char * aN ) const {
	return ::strcmp( CFurserSrMacr::MacroName(), aN ? aN : "" ) == 0;
}

// --------------------------------------------------------------------
bool CFurserSrMacr::operator != ( const char * aN ) const {
	return ::strcmp( CFurserSrMacr::MacroName(), aN ? aN : "" ) != 0;
}

// --------------------------------------------------------------------
void	CFurserSrMacr::Load		( CFurserClient & aC ) {
	CFurserSrMacr::Free();
	try {
		itsMacroName	= aC.RxData();
		itsMacroValue	= aC.RxData();
    }
    catch	( CError e ) {
    	throw CError( "CFurserSrMacr::Load", e.Error() );
    }
    catch	( ... ) {
    	throw CError( "CFurserSrMacr::Load", "Unknown error" );
    }
}

// --------------------------------------------------------------------
void	CFurserSrMacr::Save		( CFurserClient & aC ) {
	try {
		aC.TxResponse( CFurserSrMacr::MacroName() );
		aC.TxResponse( CFurserSrMacr::MacroValue() );
    }
    catch	( CError e ) {
    	throw CError( "CFurserSrMacr::Save", e.Error() );
    }
    catch	( ... ) {
    	throw CError( "CFurserSrMacr::Save", "Unknown error" );
    }
}

// --------------------------------------------------------------------
void	CFurserSrMacr::Load		( const CWinIniFile & aIni, const char * aSecName ) {
	CFurserSrMacr::Free();
	CFurserSrMacr::MacroName	( aIni.Value( aSecName, "MacroName" ) );
	CFurserSrMacr::MacroValue	( aIni.Value( aSecName, "MacroValue" ) );
}

// --------------------------------------------------------------------
void	CFurserSrMacr::Save		( CWinIniFile & aIni, const char * aSecName ) {
	CWinIniSection	sec;
    sec.Name( aSecName );
	sec.Insert( "MacroName",  CFurserSrMacr::MacroName() );
	sec.Insert( "MacroValue", CFurserSrMacr::MacroValue() );
	aIni.Insert( sec );
}

// --------------------------------------------------------------------
const char *	CFurserSrMacr::MacroName	( void ) const {
	return itsMacroName ? itsMacroName : "";
}

// --------------------------------------------------------------------
const char *	CFurserSrMacr::MacroValue	( void ) const {
	return itsMacroValue ? itsMacroValue : "";
}

// --------------------------------------------------------------------
void	CFurserSrMacr::MacroName	( const char * aV ) {
	if	( itsMacroName ) delete [] itsMacroName;
	itsMacroName = ::my_private_strdup( aV );
}

// --------------------------------------------------------------------
void	CFurserSrMacr::MacroValue	( const char * aV ) {
	if	( itsMacroValue ) delete [] itsMacroValue;
	itsMacroValue = ::my_private_strdup( aV );
}

// --------------------------------------------------------------------
void	CFurserSrMacr::Free		( void ) {
	if	( itsMacroName ) 	delete [] itsMacroName;
	if	( itsMacroValue ) 	delete [] itsMacroValue;
	CFurserSrMacr::Cleanup();
}

// --------------------------------------------------------------------
void	CFurserSrMacr::Cleanup	( void )  {
	itsMacroName	= NULL;
	itsMacroValue	= NULL;
}

// --------------------------------------------------------------------
// EOF:	CFurserSrMacr.cpp
// --------------------------------------------------------------------
