// --------------------------------------------------------------------
// CFurserSrSetn.cpp
// Whatis:  Furser Server Details class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#include	"CFurserSrSetn.h"
#include	"CError.hxx"

// --------------------------------------------------------------------
CFurserSrSetn::CFurserSrSetn	() {
	CFurserSrSetn::Cleanup();
}

// --------------------------------------------------------------------
CFurserSrSetn::~CFurserSrSetn	() {
	CFurserSrSetn::Free();
}

// --------------------------------------------------------------------
CFurserSrSetn::CFurserSrSetn	( const CFurserSrSetn & aC ) {
	CFurserSrSetn::Cleanup();
	*this = aC;
}

// --------------------------------------------------------------------
CFurserSrSetn & CFurserSrSetn::operator =	( const CFurserSrSetn & aC ) {
	CFurserSrSetn::Free();
	CFurserSrSetn::SettingName	( aC.SettingName() );
	CFurserSrSetn::SettingValu	( aC.SettingValu() );
	CFurserSrSetn::IniFileName	( aC.IniFileName() );
	CFurserSrSetn::IniSectName	( aC.IniSectName() );
	CFurserSrSetn::IniItemName	( aC.IniItemName() );
	CFurserSrSetn::NoReplacing	( aC.NoReplacing() );
	return *this;
}

// --------------------------------------------------------------------
bool CFurserSrSetn::operator == ( const CFurserSrSetn & aC ) const {
	return	*this == aC.SettingName();
}

// --------------------------------------------------------------------
bool CFurserSrSetn::operator != ( const CFurserSrSetn & aC ) const {
	return	*this != aC.SettingName();
}

// --------------------------------------------------------------------
bool CFurserSrSetn::operator == ( const char * aN ) const {
	return	::strcmp( CFurserSrSetn::SettingName(), aN ? aN : "" ) == 0;
}

// --------------------------------------------------------------------
bool CFurserSrSetn::operator != ( const char * aN ) const {
	return	::strcmp( CFurserSrSetn::SettingName(), aN ? aN : "" ) != 0;
}

// --------------------------------------------------------------------
void	CFurserSrSetn::Load	( CFurserClient & aC ) {
	CFurserSrSetn::Free();
	try {
		itsSettingName	= aC.RxData();
		itsSettingValu	= aC.RxData();
		itsIniFileName	= aC.RxData();
		itsIniSectName	= aC.RxData();
		itsIniItemName	= aC.RxData();
		itsNoReplacing	= aC.RxDataBool();
    }
    catch	( CError e ) {
    	throw CError( "CFurserSrSetn::Load", e.Error() );
    }
    catch	( ... ) {
    	throw CError( "CFurserSrSetn::Load", "Unknown error" );
    }
}

// --------------------------------------------------------------------
void	CFurserSrSetn::Save	( CFurserClient & aC ) {
	try {
		aC.TxResponse( CFurserSrSetn::SettingName() );
		aC.TxResponse( CFurserSrSetn::SettingValu() );
		aC.TxResponse( CFurserSrSetn::IniFileName() );
		aC.TxResponse( CFurserSrSetn::IniSectName() );
		aC.TxResponse( CFurserSrSetn::IniItemName() );
		aC.TxDataBool( itsNoReplacing );
    }
    catch	( CError e ) {
    	throw CError( "CFurserSrSetn::Save", e.Error() );
    }
    catch	( ... ) {
    	throw CError( "CFurserSrSetn::Save", "Unknown error" );
    }
}

// --------------------------------------------------------------------
void	CFurserSrSetn::Load	( const CWinIniFile & aIni, const char * aSecName ) {
	CFurserSrSetn::Free();
	CFurserSrSetn::SettingName	( aIni.Value( aSecName, "SettingName" ) );
	CFurserSrSetn::SettingValu	( aIni.Value( aSecName, "SettingValu" ) );
	CFurserSrSetn::IniFileName	( aIni.Value( aSecName, "IniFileName" ) );
	CFurserSrSetn::IniSectName	( aIni.Value( aSecName, "IniSectName" ) );
	CFurserSrSetn::IniItemName	( aIni.Value( aSecName, "IniItemName" ) );
	CFurserSrSetn::NoReplacing	( aIni.BoolValue( aSecName, "NoReplacing" ) );
}

// --------------------------------------------------------------------
void	CFurserSrSetn::Save	( CWinIniFile & aIni, const char * aSecName ) {
	CWinIniSection	sec;
    sec.Name( aSecName );
	sec.Insert( "SettingName", CFurserSrSetn::SettingName() );
	sec.Insert( "SettingValu", CFurserSrSetn::SettingValu() );
	sec.Insert( "IniFileName", CFurserSrSetn::IniFileName() );
	sec.Insert( "IniSectName", CFurserSrSetn::IniSectName() );
	sec.Insert( "IniItemName", CFurserSrSetn::IniItemName() );
	sec.Insert( "NoReplacing", CFurserSrSetn::NoReplacing() );
	aIni.Insert( sec );
}

// --------------------------------------------------------------------
const char *	CFurserSrSetn::SettingName	( void ) const {
	return itsSettingName ? itsSettingName : "";
}

// --------------------------------------------------------------------
const char *	CFurserSrSetn::SettingValu	( void ) const {
	return itsSettingValu ? itsSettingValu : "";
}

// --------------------------------------------------------------------
const char *	CFurserSrSetn::IniFileName	( void ) const {
	return itsIniFileName ? itsIniFileName : "";
}

// --------------------------------------------------------------------
const char *	CFurserSrSetn::IniSectName	( void ) const {
	return itsIniSectName ? itsIniSectName : "";
}

// --------------------------------------------------------------------
const char *	CFurserSrSetn::IniItemName	( void ) const {
	return itsIniItemName ? itsIniItemName : "";
}

// --------------------------------------------------------------------
bool			CFurserSrSetn::NoReplacing	( void ) const {
	return itsNoReplacing;
}

// --------------------------------------------------------------------
void			CFurserSrSetn::SettingName	( const char * aV ) {
	if	( itsSettingName ) delete [] itsSettingName;
	itsSettingName = ::my_private_strdup( aV );
}

// --------------------------------------------------------------------
void			CFurserSrSetn::SettingValu	( const char * aV ) {
	if	( itsSettingValu ) delete [] itsSettingValu;
	itsSettingValu = ::my_private_strdup( aV );
}

// --------------------------------------------------------------------
void			CFurserSrSetn::IniFileName	( const char * aV ) {
	if	( itsIniFileName ) delete [] itsIniFileName;
	itsIniFileName = ::my_private_strdup( aV );
}

// --------------------------------------------------------------------
void			CFurserSrSetn::IniSectName	( const char * aV ) {
	if	( itsIniSectName ) delete [] itsIniSectName;
	itsIniSectName = ::my_private_strdup( aV );
}

// --------------------------------------------------------------------
void			CFurserSrSetn::IniItemName	( const char * aV ) {
	if	( itsIniItemName ) delete [] itsIniItemName;
	itsIniItemName = ::my_private_strdup( aV );
}

// --------------------------------------------------------------------
void			CFurserSrSetn::NoReplacing	( bool aV ) {
	itsNoReplacing = aV;
}

// --------------------------------------------------------------------
void	CFurserSrSetn::Free	( void ) {
	if	( itsSettingName ) delete [] itsSettingName;
	if	( itsSettingValu ) delete [] itsSettingValu;
	if	( itsIniFileName ) delete [] itsIniFileName;
	if	( itsIniSectName ) delete [] itsIniSectName;
	if	( itsIniItemName ) delete [] itsIniItemName;
	CFurserSrSetn::Cleanup();
}

// --------------------------------------------------------------------
void	CFurserSrSetn::Cleanup	( void ) {
	itsSettingName = NULL;
	itsSettingValu = NULL;
	itsIniFileName = NULL;
	itsIniSectName = NULL;
	itsIniItemName = NULL;
    itsNoReplacing = false;
}

// --------------------------------------------------------------------
// EOF:	CFurserSrSetn.cpp
// --------------------------------------------------------------------
