// --------------------------------------------------------------------
// CFurserSrSrvr.cpp
// Whatis:  Furser Server Details class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#include	"CFurserSrSrvr.h"
#include	"CError.hxx"

// --------------------------------------------------------------------
CFurserSrSrvr::CFurserSrSrvr	() {
	CFurserSrSrvr::Cleanup();
}

// --------------------------------------------------------------------
CFurserSrSrvr::~CFurserSrSrvr	() {
	CFurserSrSrvr::Free();
}

// --------------------------------------------------------------------
CFurserSrSrvr::CFurserSrSrvr	( const CFurserSrSrvr & aC ) {
	CFurserSrSrvr::Cleanup();
    *this = aC;
}

// --------------------------------------------------------------------
CFurserSrSrvr & CFurserSrSrvr::operator =	( const CFurserSrSrvr & aC ) {
	CFurserSrSrvr::Free();
	itsSettingList	= aC.SettingList();
	itsEventList	= aC.EventList();
	itsGroupList	= aC.GroupList();
	itsUserList		= aC.UserList();
	itsBanList		= aC.BanList();
	itsMutatorList	= aC.MutatorList();
	itsGameList		= aC.GameList();
	itsMapList		= aC.MapList();
	itsMacroList	= aC.MacroList();
	CFurserSrSrvr::Running		( aC.Running() );
	CFurserSrSrvr::GameRunning	( aC.GameRunning() );
	CFurserSrSrvr::ServerType	( aC.ServerType() );
	CFurserSrSrvr::ServerName	( aC.ServerName() );
	CFurserSrSrvr::GameRoot		( aC.GameRoot() );
	CFurserSrSrvr::ExtraUccFlags( aC.ExtraUccFlags() );
	CFurserSrSrvr::UsesAdminName( aC.UsesAdminName() );
	CFurserSrSrvr::AdminName	( aC.AdminName() );
	CFurserSrSrvr::AdminPass	( aC.AdminPass() );
	CFurserSrSrvr::UsesGamePass	( aC.UsesGamePass() );
	CFurserSrSrvr::GamePass		( aC.GamePass() );
	CFurserSrSrvr::UsesWebAdmin	( aC.UsesWebAdmin() );
	CFurserSrSrvr::WebAdminPort	( aC.WebAdminPort() );
    return *this;
}

// --------------------------------------------------------------------
bool CFurserSrSrvr::operator == ( const CFurserSrSrvr & aC ) const {
	return *this == aC.ServerName();
}

// --------------------------------------------------------------------
bool CFurserSrSrvr::operator != ( const CFurserSrSrvr & aC ) const {
	return *this != aC.ServerName();
}

// --------------------------------------------------------------------
bool CFurserSrSrvr::operator == ( const char * aN ) const {
	return ::strcmp( CFurserSrSrvr::ServerName(), aN ? aN : "" ) == 0;
}

// --------------------------------------------------------------------
bool CFurserSrSrvr::operator != ( const char * aN ) const {
	return ::strcmp( CFurserSrSrvr::ServerName(), aN ? aN : "" ) != 0;
}

// --------------------------------------------------------------------
dword_t	CFurserSrSrvr::ProgressCalc	( void ) {
	return	  (dword_t)itsSettingList.size()
    		+ (dword_t)itsEventList.size()
            + (dword_t)itsGroupList.size()
            + (dword_t)itsUserList.size()
            + (dword_t)itsBanList.size()
            + (dword_t)itsMutatorList.size()
            + (dword_t)itsGameList.size()
            + (dword_t)itsMapList.size()
            + (dword_t)itsMacroList.size()
            + 1 + 13;
}

// --------------------------------------------------------------------
bool	CFurserSrSrvr::FirstMap	( const CFurserSrLevl & aM ) const {
	return itsMapList.size() > 0 ? itsMapList.front() == aM : false;
}

// --------------------------------------------------------------------
bool	CFurserSrSrvr::LastMap		( const CFurserSrLevl & aM ) const {
	return itsMapList.size() > 0 ? itsMapList.back() == aM : false;
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::Earlier		( const CFurserSrLevl & aM, bool aRm ) {
	CFurserSrLevl_l		mylist;
	CFurserSrLevl_li	loop;
    int					position	= 0;
    int					posold		= -1;
    int					posnew		= -1;

	for	(	loop  = itsMapList.begin();
    		loop != itsMapList.end();
            loop++, position++ ) {
    	if	( (*loop) == aM ) {
        	posold = position;
        	break;
        }
		if	( ( !aRm ) || ( (*loop).Rotate() ) ) {
        	posnew = position;
        }
    }

	if	( ( posold >= 0 ) && ( posnew >= 0 ) ) {
		position = 0;
		for	(	loop  = itsMapList.begin();
    			loop != itsMapList.end();
        	    loop++, position++ ) {
        	if		( position == posnew ) {
    	        	mylist.push_back( aM );
        	        mylist.push_back( *loop );
            }
            else if	( position != posold ) {
            	mylist.push_back( *loop );
            }
	    }

		itsMapList = mylist;
        CFurserSrSrvr::Renumber();
	}
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::Later		( const CFurserSrLevl & aM, bool aRm ) {
	CFurserSrLevl_l		mylist;
	CFurserSrLevl_li	loop;
    int					position	= 0;
    int					posold		= -1;
    int					posnew		= -1;

	for	(	loop  = itsMapList.begin();
    		loop != itsMapList.end();
            loop++, position++ ) {
		if	( ( !aRm ) || ( (*loop).Rotate() ) ) {
        	if	( posold >= 0 ) {
	        	posnew = position;
                break;
            }
        }
    	if	( (*loop) == aM ) {
        	posold = position;
        }
    }

	if	( ( posold >= 0 ) && ( posnew >= 0 ) ) {
		position = 0;
		for	(	loop  = itsMapList.begin();
    			loop != itsMapList.end();
        	    loop++, position++ ) {
        	if		( position == posnew ) {
        	        mylist.push_back( *loop );
    	        	mylist.push_back( aM );
            }
            else if	( position != posold ) {
            	mylist.push_back( *loop );
            }
	    }

		itsMapList = mylist;
        CFurserSrSrvr::Renumber();
	}
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::Renumber		( void ) {
	CFurserSrLevl_li	loop;
	int					position = 0;

	for	(	loop  = itsMapList.begin();
   			loop != itsMapList.end();
       	    loop++, position++ ) {
    	(*loop).Order( position );
    }
}

// --------------------------------------------------------------------
int		CFurserSrSrvr::RotateCount	( void ) const {
	int					count = 0;
	CFurserSrLevl_lci	loop;
	for	(	loop  = itsMapList.begin();
   			loop != itsMapList.end();
       	    loop++ ) {
    	if	( (*loop).Rotate() ) {
        	count++;
        }
    }
    return	count;
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::ScanLoadFlags( void ) {
	CFurserSrMuta_li	loop;
	CFurserSrMuta_li	rest;

	for	(	loop  = itsMutatorList.begin();
   			loop != itsMutatorList.end();
       	    loop++ ) {
		if	( ! (*loop).LoadFlag() )	continue;
        if	( (*loop).Group()[0] == 0 )	continue;
        rest = loop;
        rest++;
        while	( rest != itsMutatorList.end() ) {
			if	( ! ::strcmp( (*rest).Group(), (*loop).Group() ) ) {
            	(*rest).LoadFlag( false );
            }
        }
    }
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::SetLoadFlag( const char * aM, bool aF ) {
	const char *		group = NULL;
	CFurserSrMuta_li	loop;
	for	(	loop  = itsMutatorList.begin();
   			loop != itsMutatorList.end();
       	    loop++ ) {
    	if	( *loop == aM ) {
        	group = (*loop).Group();
            (*loop).LoadFlag( aF );
            break;
        }
	}
    if	( ! aF )			return;
    if	( ! group )			return;
    if	( group[0] == 0 )	return;

	for	(	loop  = itsMutatorList.begin();
   			loop != itsMutatorList.end();
       	    loop++ ) {
    	if	( *loop == aM )	continue;
		if	( ! (*loop).LoadFlag() )	continue;
        if	( ::strcmp( (*loop).Group(), group ) )	continue;
        (*loop).LoadFlag( false );
	}
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::ExpandMacros	( char * aStr, size_t aRoom ) const {
	CFurserSrMacr_lci	macr;
	char *				newdata	= NULL;
    char *				tail	= NULL;
    char *				rp;
    int					sl;

	try {
    	newdata = new char [aRoom];
        ::strcpy( newdata, aStr );

		for	( macr = itsMacroList.begin(); macr != itsMacroList.end(); macr++ ) {
        	sl = ::strlen( (*macr).MacroName() );
        	rp = ::strstr( newdata, (*macr).MacroName() );
			while	( rp ) {
            	if	( ( ::strlen( newdata )	- sl + ::strlen( (*macr).MacroValue() ) ) >= aRoom - 1 ) {
                	throw CError( "Macro would expand too much" );
                }
				tail = ::my_private_strdup( rp + sl );
                ::strcpy( rp, (*macr).MacroValue() );
                ::strcat( rp, tail ? tail : "" );
				if	( tail )	delete [] tail;
                tail = NULL;
	        	rp = ::strstr( newdata, (*macr).MacroName() );
            }
        }

        ::strcpy( aStr, newdata );
        delete [] newdata;
    }

    catch	( ... ) {
		if	( newdata )	delete [] newdata;
        if	( tail )	delete [] tail;
		throw;
    }
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::GameConfigFiles	( const char * aPath, char aPathSep ) const {
	CFurserString_l		filelist;
	CFurserString_li	loop;

    // Find names of the config files
	filelist = CFurserSrSrvr::ListConfigFiles();

    // Recreate all the config files
    for	( loop = filelist.begin(); loop != filelist.end(); loop++ ) {

    	// Ini file receives separate treatment
		if	( *loop == CFurserSrSrvr::GetMacro( "$(Ini)" ).MacroValue() ) {
        	CFurserSrSrvr::CreateMainIniFile( aPath, aPathSep, (*loop).c_str() );
        }
		else {
            CFurserSrSrvr::CreateOthrIniFile( aPath, aPathSep, (*loop).c_str() );
        }
	}

    // Authorization
    CFurserSrSrvr::CreateAuthIniFile( aPath, aPathSep );
}


// --------------------------------------------------------------------
void	CFurserSrSrvr::Load		( CFurserClient & aC, dword_t & aPos ) {
	dword_t	count, i;
	CFurserSrSrvr::Free();

	itsRunning		= aC.RxDataBool();
    aPos++;
	itsGameRunning	= aC.RxDataBool();
    aPos++;
	itsServerType	= aC.RxDataInt();
    aPos++;
	itsServerName	= aC.RxData();
    aPos++;
	itsGameRoot		= aC.RxData();
    aPos++;
	itsExtraUccFlags= aC.RxData();
    aPos++;
	itsUsesAdminName= aC.RxDataBool();
    aPos++;
	itsAdminName	= aC.RxData();
    aPos++;
	itsAdminPass	= aC.RxData();
    aPos++;
	itsUsesGamePass	= aC.RxDataBool();
    aPos++;
	itsGamePass		= aC.RxData();
    aPos++;
	itsUsesWebAdmin	= aC.RxDataBool();
    aPos++;
	itsWebAdminPort	= (unsigned short)aC.RxDataDword();
    aPos++;

    count = aC.RxDataDword();
    for	( i = 0; i < count; i++ ) {
    	CFurserSrSetn mydata;
        mydata.Load( aC );
        itsSettingList.push_back( mydata );
        aPos++;
    }

    count = aC.RxDataDword();
    for	( i = 0; i < count; i++ ) {
    	CFurserSrEvnt mydata;
        mydata.Load( aC );
        itsEventList.push_back( mydata );
        aPos++;
    }

    count = aC.RxDataDword();
    for	( i = 0; i < count; i++ ) {
    	CFurserSrGrup mydata;
        mydata.Load( aC );
        itsGroupList.push_back( mydata );
        aPos++;
    }

    count = aC.RxDataDword();
    for	( i = 0; i < count; i++ ) {
    	CFurserSrUser mydata;
        mydata.Load( aC );
        itsUserList.push_back( mydata );
        aPos++;
    }

    count = aC.RxDataDword();
    for	( i = 0; i < count; i++ ) {
    	CFurserSrUban mydata;
        mydata.Load( aC );
        itsBanList.push_back( mydata );
        aPos++;
    }

    count = aC.RxDataDword();
    for	( i = 0; i < count; i++ ) {
    	CFurserSrMuta mydata;
        mydata.Load( aC );
        itsMutatorList.push_back( mydata );
        aPos++;
    }

    count = aC.RxDataDword();
    for	( i = 0; i < count; i++ ) {
    	CFurserSrGame mydata;
        mydata.Load( aC );
        itsGameList.push_back( mydata );
        aPos++;
    }

    count = aC.RxDataDword();
    for	( i = 0; i < count; i++ ) {
    	CFurserSrLevl mydata;
        mydata.Load( aC );
        itsMapList.push_back( mydata );
        aPos++;
    }

    count = aC.RxDataDword();
    for	( i = 0; i < count; i++ ) {
    	CFurserSrMacr mydata;
        mydata.Load( aC );
        itsMacroList.push_back( mydata );
        aPos++;
    }

	aC.TxResponse( "CFurserSrSrvr OK\n" );
    aPos++;

    // Done to set initial values to the macro list
	ServerType		( itsServerType );
	ServerName		( itsServerName );
	GameRoot		( itsGameRoot );
	ExtraUccFlags	( itsExtraUccFlags );
	UsesAdminName	( itsUsesAdminName );
	AdminName		( itsAdminName );
	AdminPass		( itsAdminPass );
	UsesGamePass	( itsUsesGamePass );
	GamePass		( itsGamePass );
	UsesWebAdmin	( itsUsesWebAdmin );
	WebAdminPort	( itsWebAdminPort );
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::Save		( CFurserClient & aC, dword_t & aPos ) {

	aC.TxDataBool( itsRunning );
    aPos++;
	aC.TxDataBool( itsGameRunning );
    aPos++;
	aC.TxDataInt( itsServerType );
    aPos++;
	aC.TxResponse( CFurserSrSrvr::ServerName() );
    aPos++;
    aC.TxResponse( CFurserSrSrvr::GameRoot() );
    aPos++;
	aC.TxResponse( CFurserSrSrvr::ExtraUccFlags() );
    aPos++;
	aC.TxDataBool( itsUsesAdminName );
    aPos++;
	aC.TxResponse( CFurserSrSrvr::AdminName() );
    aPos++;
    aC.TxResponse( CFurserSrSrvr::AdminPass() );
    aPos++;
	aC.TxDataBool( itsUsesGamePass );
    aPos++;
	aC.TxResponse( CFurserSrSrvr::GamePass() );
    aPos++;
	aC.TxDataBool( itsUsesWebAdmin );
    aPos++;
    aC.TxDataDword( (dword_t)itsWebAdminPort );
    aPos++;

    aC.TxDataDword( (dword_t)itsSettingList.size() );
    for	( CFurserSrSetn_li loop = itsSettingList.begin(); loop != itsSettingList.end(); loop++ ) {
        (*loop).Save( aC );
	    aPos++;
    }

    aC.TxDataDword( (dword_t)itsEventList.size() );
    for	( CFurserSrEvnt_li loop = itsEventList.begin(); loop != itsEventList.end(); loop++ ) {
        (*loop).Save( aC );
	    aPos++;
    }

    aC.TxDataDword( (dword_t)itsGroupList.size() );
    for	( CFurserSrGrup_li loop = itsGroupList.begin(); loop != itsGroupList.end(); loop++ ) {
        (*loop).Save( aC );
	    aPos++;
    }

    aC.TxDataDword( (dword_t)itsUserList.size() );
    for	( CFurserSrUser_li loop = itsUserList.begin(); loop != itsUserList.end(); loop++ ) {
        (*loop).Save( aC );
	    aPos++;
    }

    aC.TxDataDword( (dword_t)itsBanList.size() );
    for	( CFurserSrUban_li loop = itsBanList.begin(); loop != itsBanList.end(); loop++ ) {
        (*loop).Save( aC );
	    aPos++;
    }

    aC.TxDataDword( (dword_t)itsMutatorList.size() );
    for	( CFurserSrMuta_li loop = itsMutatorList.begin(); loop != itsMutatorList.end(); loop++ ) {
        (*loop).Save( aC );
	    aPos++;
    }

    aC.TxDataDword( (dword_t)itsGameList.size() );
    for	( CFurserSrGame_li loop = itsGameList.begin(); loop != itsGameList.end(); loop++ ) {
        (*loop).Save( aC );
	    aPos++;
    }

    aC.TxDataDword( (dword_t)itsMapList.size() );
    for	( CFurserSrLevl_li loop = itsMapList.begin(); loop != itsMapList.end(); loop++ ) {
        (*loop).Save( aC );
	    aPos++;
    }

    aC.TxDataDword( (dword_t)itsMacroList.size() );
    for	( CFurserSrMacr_li loop = itsMacroList.begin(); loop != itsMacroList.end(); loop++ ) {
        (*loop).Save( aC );
	    aPos++;
    }

	aC.RxResponse( "CFurserSrSrvr OK\n" );
    aPos++;

}

// --------------------------------------------------------------------
void	CFurserSrSrvr::Load		( const CWinIniFile & aIni, const char * aSecName ) {
	dword_t	count, i;
	char	secname[64];
	CFurserSrSrvr::Free();

	CFurserSrSrvr::Running		( aIni.BoolValue( aSecName, "Running" ) );
	CFurserSrSrvr::ServerType	( aIni.IntValue	( aSecName, "ServerType" ) );
	CFurserSrSrvr::ServerName	( aIni.Value( aSecName, "ServerName" ) );
	CFurserSrSrvr::GameRoot		( aIni.Value( aSecName, "GameRoot" ) );
	CFurserSrSrvr::ExtraUccFlags( aIni.Value( aSecName, "ExtraUccFlags" ) );
	CFurserSrSrvr::UsesAdminName( aIni.BoolValue( aSecName, "UsesAdminName" ) );
	CFurserSrSrvr::AdminName	( aIni.Value( aSecName, "AdminName" ) );
	CFurserSrSrvr::AdminPass	( aIni.Value( aSecName, "AdminPass" ) );
	CFurserSrSrvr::UsesGamePass	( aIni.BoolValue( aSecName, "UsesGamePass" ) );
	CFurserSrSrvr::GamePass		( aIni.Value( aSecName, "GamePass" ) );
	CFurserSrSrvr::UsesWebAdmin	( aIni.BoolValue( aSecName, "UsesWebAdmin" ) );
	CFurserSrSrvr::WebAdminPort	( (unsigned short)aIni.IntValue	( aSecName, "WebAdminPort" ) );


    count = aIni.IntValue( aSecName, "SettingListCount" );
    for	( i = 0; i < count; i++ ) {
		::sprintf( secname, "%s.Setting_%d", aSecName, i );
    	CFurserSrSetn mydata;
        mydata.Load( aIni, secname );
        CFurserSrSrvr::AddSetting( mydata );
    }

    count = aIni.IntValue( aSecName, "EventListCount" );
    for	( i = 0; i < count; i++ ) {
		::sprintf( secname, "%s.Event_%d", aSecName, i );
    	CFurserSrEvnt mydata;
        mydata.Load( aIni, secname );
        CFurserSrSrvr::AddEvent( mydata );
    }

    count = aIni.IntValue( aSecName, "GroupListCount" );
    for	( i = 0; i < count; i++ ) {
		::sprintf( secname, "%s.Group_%d", aSecName, i );
    	CFurserSrGrup mydata;
        mydata.Load( aIni, secname );
        CFurserSrSrvr::AddGroup( mydata );
    }

    count = aIni.IntValue( aSecName, "UserListCount" );
    for	( i = 0; i < count; i++ ) {
		::sprintf( secname, "%s.User_%d", aSecName, i );
    	CFurserSrUser mydata;
        mydata.Load( aIni, secname );
        CFurserSrSrvr::AddUser( mydata );
    }

    count = aIni.IntValue( aSecName, "BanListCount" );
    for	( i = 0; i < count; i++ ) {
		::sprintf( secname, "%s.Ban_%d", aSecName, i );
    	CFurserSrUban mydata;
        mydata.Load( aIni, secname );
        CFurserSrSrvr::AddBan( mydata );
    }

    count = aIni.IntValue( aSecName, "MutatorListCount" );
    for	( i = 0; i < count; i++ ) {
		::sprintf( secname, "%s.Mutator_%d", aSecName, i );
    	CFurserSrMuta mydata;
        mydata.Load( aIni, secname );
        CFurserSrSrvr::AddMutator( mydata );
    }

    count = aIni.IntValue( aSecName, "GameListCount" );
    for	( i = 0; i < count; i++ ) {
		::sprintf( secname, "%s.Game_%d", aSecName, i );
    	CFurserSrGame mydata;
        mydata.Load( aIni, secname );
        CFurserSrSrvr::AddGame( mydata );
    }

    count = aIni.IntValue( aSecName, "MapListCount" );
    for	( i = 0; i < count; i++ ) {
		::sprintf( secname, "%s.Map_%d", aSecName, i );
    	CFurserSrLevl mydata;
        mydata.Load( aIni, secname );
        CFurserSrSrvr::AddMap( mydata );
    }

    count = aIni.IntValue( aSecName, "MacroListCount" );
    for	( i = 0; i < count; i++ ) {
		::sprintf( secname, "%s.Macro_%d", aSecName, i );
    	CFurserSrMacr mydata;
        mydata.Load( aIni, secname );
        CFurserSrSrvr::AddMacro( mydata );
    }

    // Done to set initial values to the macro list
	ServerType		( itsServerType );
	ServerName		( itsServerName );
	GameRoot		( itsGameRoot );
	ExtraUccFlags	( itsExtraUccFlags );
	UsesAdminName	( itsUsesAdminName );
	AdminName		( itsAdminName );
	AdminPass		( itsAdminPass );
	UsesGamePass	( itsUsesGamePass );
	GamePass		( itsGamePass );
	UsesWebAdmin	( itsUsesWebAdmin );
	WebAdminPort	( itsWebAdminPort );
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::Save		( CWinIniFile & aIni, const char * aSecName ) {
	CWinIniSection	sec;
    dword_t			i;
	char			secname[64];

    sec.Name( aSecName );
	sec.Insert( "Running", itsRunning );
	sec.Insert( "ServerType", itsServerType );
	sec.Insert( "ServerName", CFurserSrSrvr::ServerName() );
	sec.Insert( "GameRoot", CFurserSrSrvr::GameRoot() );
	sec.Insert( "ExtraUccFlags", CFurserSrSrvr::ExtraUccFlags() );
	sec.Insert( "UsesAdminName", itsUsesAdminName );
	sec.Insert( "AdminName", CFurserSrSrvr::AdminName() );
	sec.Insert( "AdminPass", CFurserSrSrvr::AdminPass() );
	sec.Insert( "UsesGamePass", itsUsesGamePass );
	sec.Insert( "GamePass", CFurserSrSrvr::GamePass() );
	sec.Insert( "UsesWebAdmin", itsUsesWebAdmin );
	sec.Insert( "WebAdminPort", (int)itsWebAdminPort );
	sec.Insert( "SettingListCount", (int)itsSettingList.size() );
	sec.Insert( "EventListCount", (int)itsEventList.size() );
	sec.Insert( "GroupListCount", (int)itsGroupList.size() );
	sec.Insert( "UserListCount", (int)itsUserList.size() );
	sec.Insert( "BanListCount", (int)itsBanList.size() );
	sec.Insert( "MutatorListCount", (int)itsMutatorList.size() );
	sec.Insert( "GameListCount", (int)itsGameList.size() );
	sec.Insert( "MapListCount", (int)itsMapList.size() );
	sec.Insert( "MacroListCount", (int)itsMacroList.size() );
	aIni.Insert( sec );

	i = 0;
    for	( CFurserSrSetn_li loop = itsSettingList.begin(); loop != itsSettingList.end(); loop++ ) {
		::sprintf( secname, "%s.Setting_%d", aSecName, i );
    	(*loop).Save( aIni, secname );
        i++;
    }

	i = 0;
    for	( CFurserSrEvnt_li loop = itsEventList.begin(); loop != itsEventList.end(); loop++ ) {
		::sprintf( secname, "%s.Event_%d", aSecName, i );
    	(*loop).Save( aIni, secname );
        i++;
    }

	i = 0;
    for	( CFurserSrGrup_li loop = itsGroupList.begin(); loop != itsGroupList.end(); loop++ ) {
		::sprintf( secname, "%s.Group_%d", aSecName, i );
    	(*loop).Save( aIni, secname );
        i++;
    }

	i = 0;
    for	( CFurserSrUser_li loop = itsUserList.begin(); loop != itsUserList.end(); loop++ ) {
		::sprintf( secname, "%s.User_%d", aSecName, i );
    	(*loop).Save( aIni, secname );
        i++;
    }

	i = 0;
    for	( CFurserSrUban_li loop = itsBanList.begin(); loop != itsBanList.end(); loop++ ) {
		::sprintf( secname, "%s.Ban_%d", aSecName, i );
    	(*loop).Save( aIni, secname );
        i++;
    }

	i = 0;
    for	( CFurserSrMuta_li loop = itsMutatorList.begin(); loop != itsMutatorList.end(); loop++ ) {
		::sprintf( secname, "%s.Mutator_%d", aSecName, i );
    	(*loop).Save( aIni, secname );
        i++;
    }

	i = 0;
    for	( CFurserSrGame_li loop = itsGameList.begin(); loop != itsGameList.end(); loop++ ) {
		::sprintf( secname, "%s.Game_%d", aSecName, i );
    	(*loop).Save( aIni, secname );
        i++;
    }

	i = 0;
    for	( CFurserSrLevl_li loop = itsMapList.begin(); loop != itsMapList.end(); loop++ ) {
		::sprintf( secname, "%s.Map_%d", aSecName, i );
    	(*loop).Save( aIni, secname );
        i++;
    }

   	i = 0;
    for	( CFurserSrMacr_li loop = itsMacroList.begin(); loop != itsMacroList.end(); loop++ ) {
		::sprintf( secname, "%s.Macro_%d", aSecName, i );
    	(*loop).Save( aIni, secname );
        i++;
    }
}

// --------------------------------------------------------------------
bool	CFurserSrSrvr::HasSetting	( const char * aN ) const {
	CFurserSrSetn_lci	loop;
    for	(	loop  = itsSettingList.begin();
    		loop != itsSettingList.end();
            loop++ ) {
    	if	( *loop == aN )	return true;
    }
    return false;
}

// --------------------------------------------------------------------
CFurserSrSetn	CFurserSrSrvr::GetSetting	( const char * aN ) const {
	CFurserSrSetn_lci	loop;
    for	(	loop  = itsSettingList.begin();
    		loop != itsSettingList.end();
            loop++ ) {
    	if	( *loop == aN )	return *loop;
    }
    CFurserSrSetn dummy;
    return dummy;
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::SetSetting	( const char * aN, const CFurserSrSetn & aC ) {
	if	( ( ! CFurserSrSrvr::HasSetting( aC.SettingName() ) ) || ( aC == aN ) ) {
		CFurserSrSetn_li	loop;
    	for	(	loop  = itsSettingList.begin();
				loop != itsSettingList.end();
            	loop++ ) {
	    	if	( *loop == aN ) {
    	    	*loop = aC;
        	    break;
            }
        }
    }
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::AddSetting	( const CFurserSrSetn & aC ) {
	if		( aC == "#SEQUENCE" ) {
		CFurserSrSetn_lci	loop;
		long				sequ = 0;
		char				name[32];
    	for	(	loop  = itsSettingList.begin();
				loop != itsSettingList.end();
            	loop++ ) {
			if	( (*loop).SettingName()[0] == '#' ) {
				long	comp = ::atol( (*loop).SettingName() + 1 );
				if	( comp >= sequ )	sequ = comp + 1;
			}
		}
		::sprintf( name, "#%li", sequ );
		itsSettingList.push_back( aC );
		itsSettingList.back().SettingName( name );
	}
	else if	( ! CFurserSrSrvr::HasSetting( aC.SettingName() ) ) {
    	itsSettingList.push_back( aC );
    }
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::DelSetting	( const CFurserSrSetn & aC ) {
	itsSettingList.remove( aC );
}

// --------------------------------------------------------------------
bool	CFurserSrSrvr::HasEvent	( const char * aN ) const {
	CFurserSrEvnt_lci	loop;
    for	(	loop  = itsEventList.begin();
    		loop != itsEventList.end();
            loop++ ) {
    	if	( *loop == aN )	return true;
    }
    return false;
}

// --------------------------------------------------------------------
CFurserSrEvnt	CFurserSrSrvr::GetEvent	( const char * aN ) const {
	CFurserSrEvnt_lci	loop;
    for	(	loop  = itsEventList.begin();
    		loop != itsEventList.end();
            loop++ ) {
    	if	( *loop == aN )	return *loop;
    }
    CFurserSrEvnt dummy;
    return dummy;
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::SetEvent	( const char * aN, const CFurserSrEvnt & aC ) {
	if	( ( ! CFurserSrSrvr::HasEvent( aC.EventName() ) ) || ( aC == aN ) ) {
		CFurserSrEvnt_li	loop;
    	for	(	loop  = itsEventList.begin();
				loop != itsEventList.end();
            	loop++ ) {
	    	if	( *loop == aN ) {
    	    	*loop = aC;
        	    break;
            }
        }
    }
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::AddEvent	( const CFurserSrEvnt & aC ) {
	if	( ! CFurserSrSrvr::HasEvent( aC.EventName() ) ) {
    	itsEventList.push_back( aC );
    }
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::DelEvent	( const CFurserSrEvnt & aC ) {
	itsEventList.remove( aC );
}

// --------------------------------------------------------------------
bool	CFurserSrSrvr::HasGroup	( const char * aN ) const {
	CFurserSrGrup_lci	loop;
    for	(	loop  = itsGroupList.begin();
    		loop != itsGroupList.end();
            loop++ ) {
    	if	( *loop == aN )	return true;
    }
    return false;
}

// --------------------------------------------------------------------
CFurserSrGrup	CFurserSrSrvr::GetGroup	( const char * aN ) const {
	CFurserSrGrup_lci	loop;
    for	(	loop  = itsGroupList.begin();
    		loop != itsGroupList.end();
            loop++ ) {
    	if	( *loop == aN )	return *loop;
    }
    CFurserSrGrup dummy;
    return dummy;
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::SetGroup	( const char * aN, const CFurserSrGrup & aC ) {
	if	( ( ! CFurserSrSrvr::HasGroup( aC.GroupName() ) ) || ( aC == aN ) ) {
		CFurserSrGrup_li	loop;
    	for	(	loop  = itsGroupList.begin();
				loop != itsGroupList.end();
            	loop++ ) {
	    	if	( *loop == aN ) {
    	    	*loop = aC;
        	    break;
            }
        }
        // All users that have this group should also be altered
		CFurserSrUser_li	user;
    	for	(	user  = itsUserList.begin();
				user != itsUserList.end();
            	user++ ) {
			(*user).SetGroup( aN, aC );
        }
    }
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::AddGroup	( const CFurserSrGrup & aC ) {
	if	( ! CFurserSrSrvr::HasGroup( aC.GroupName() ) ) {
    	itsGroupList.push_back( aC );
    }
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::DelGroup	( const CFurserSrGrup & aC ) {
	itsGroupList.remove( aC );

    // All users having this group shoul also loose it
	CFurserSrUser_li	user;
   	for	(	user  = itsUserList.begin();
			user != itsUserList.end();
           	user++ ) {
		(*user).DelGroup( aC );
	}
}

// --------------------------------------------------------------------
bool	CFurserSrSrvr::HasUser		( const char * aN ) const {
	CFurserSrUser_lci	loop;
    for	(	loop  = itsUserList.begin();
    		loop != itsUserList.end();
            loop++ ) {
    	if	( *loop == aN )	return true;
    }
    return false;
}

// --------------------------------------------------------------------
CFurserSrUser	CFurserSrSrvr::GetUser		( const char * aN ) const {
	CFurserSrUser_lci	loop;
    for	(	loop  = itsUserList.begin();
    		loop != itsUserList.end();
            loop++ ) {
    	if	( *loop == aN )	return *loop;
    }
    CFurserSrUser dummy;
    return dummy;
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::SetUser		( const char * aN, const CFurserSrUser & aC ) {
	if	( ( ! CFurserSrSrvr::HasUser( aC.UserName() ) ) || ( aC == aN ) ) {
		CFurserSrUser_li	loop;
    	for	(	loop  = itsUserList.begin();
				loop != itsUserList.end();
            	loop++ ) {
	    	if	( *loop == aN ) {
    	    	*loop = aC;
        	    break;
            }
        }
    }
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::AddUser		( const CFurserSrUser & aC ) {
	if	( ! CFurserSrSrvr::HasUser( aC.UserName() ) ) {
    	itsUserList.push_back( aC );
    }
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::DelUser		( const CFurserSrUser & aC ) {
	itsUserList.remove( aC );
}

// --------------------------------------------------------------------
bool	CFurserSrSrvr::HasBan		( const char * aN ) const {
	CFurserSrUban_lci	loop;
    for	(	loop  = itsBanList.begin();
    		loop != itsBanList.end();
            loop++ ) {
    	if	( *loop == aN )	return true;
    }
    return false;
}

// --------------------------------------------------------------------
CFurserSrUban	CFurserSrSrvr::GetBan		( const char * aN ) const {
	CFurserSrUban_lci	loop;
    for	(	loop  = itsBanList.begin();
    		loop != itsBanList.end();
            loop++ ) {
    	if	( *loop == aN )	return *loop;
    }
    CFurserSrUban dummy;
    return dummy;
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::SetBan		( const char * aN, const CFurserSrUban & aC ) {
	if	( ( ! CFurserSrSrvr::HasBan( aC.BanName() ) ) || ( aC == aN ) ) {
		CFurserSrUban_li	loop;
    	for	(	loop  = itsBanList.begin();
				loop != itsBanList.end();
            	loop++ ) {
	    	if	( *loop == aN ) {
    	    	*loop = aC;
        	    break;
            }
        }
    }
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::AddBan		( const CFurserSrUban & aC ) {
	if	( ! CFurserSrSrvr::HasBan( aC.BanName() ) ) {
    	itsBanList.push_back( aC );
    }
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::DelBan		( const CFurserSrUban & aC ) {
	itsBanList.remove( aC );
}

// --------------------------------------------------------------------
bool	CFurserSrSrvr::HasMutator	( const char * aN ) const {
	CFurserSrMuta_lci	loop;
    for	(	loop  = itsMutatorList.begin();
    		loop != itsMutatorList.end();
            loop++ ) {
    	if	( *loop == aN )	return true;
    }
    return false;
}

// --------------------------------------------------------------------
CFurserSrMuta	CFurserSrSrvr::GetMutator	( const char * aN ) const {
	CFurserSrMuta_lci	loop;
    for	(	loop  = itsMutatorList.begin();
    		loop != itsMutatorList.end();
            loop++ ) {
    	if	( *loop == aN )	return *loop;
    }
    CFurserSrMuta dummy;
    return dummy;
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::SetMutator	( const char * aN, const CFurserSrMuta & aC ) {
	if	( ( ! CFurserSrSrvr::HasMutator( aC.MutatorName() ) ) || ( aC == aN ) ) {
		CFurserSrMuta_li	loop;
    	for	(	loop  = itsMutatorList.begin();
				loop != itsMutatorList.end();
            	loop++ ) {
	    	if	( *loop == aN ) {
    	    	*loop = aC;
        	    break;
            }
        }
    }
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::AddMutator	( const CFurserSrMuta & aC ) {
	if	( ! CFurserSrSrvr::HasMutator( aC.MutatorName() ) ) {
    	itsMutatorList.push_back( aC );
    }
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::DelMutator	( const CFurserSrMuta & aC ) {
	itsMutatorList.remove( aC );
}

// --------------------------------------------------------------------
bool	CFurserSrSrvr::HasGame		( const char * aN ) const {
	CFurserSrGame_lci	loop;
    for	(	loop  = itsGameList.begin();
    		loop != itsGameList.end();
            loop++ ) {
    	if	( *loop == aN )	return true;
    }
    return false;
}

// --------------------------------------------------------------------
CFurserSrGame	CFurserSrSrvr::GetGame		( const char * aN ) const {
	CFurserSrGame_lci	loop;
    for	(	loop  = itsGameList.begin();
    		loop != itsGameList.end();
            loop++ ) {
    	if	( *loop == aN )	return *loop;
    }
    CFurserSrGame dummy;
    return dummy;
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::SetGame		( const char * aN, const CFurserSrGame & aC ) {
	if	( ( ! CFurserSrSrvr::HasGame( aC.GameName() ) ) || ( aC == aN ) ) {
		CFurserSrGame_li	loop;
    	for	(	loop  = itsGameList.begin();
				loop != itsGameList.end();
            	loop++ ) {
	    	if	( *loop == aN ) {
    	    	*loop = aC;
        	    break;
            }
        }
    }
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::AddGame		( const CFurserSrGame & aC ) {
	if	( ! CFurserSrSrvr::HasGame( aC.GameName() ) ) {
    	itsGameList.push_back( aC );
    }
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::DelGame		( const CFurserSrGame & aC ) {
	itsGameList.remove( aC );
}

// --------------------------------------------------------------------
bool	CFurserSrSrvr::HasMap		( const char * aN ) const {
	CFurserSrLevl_lci	loop;
    for	(	loop  = itsMapList.begin();
    		loop != itsMapList.end();
            loop++ ) {
    	if	( *loop == aN )	return true;
    }
    return false;
}

// --------------------------------------------------------------------
CFurserSrLevl	CFurserSrSrvr::GetMap		( const char * aN ) const {
	CFurserSrLevl_lci	loop;
    for	(	loop  = itsMapList.begin();
    		loop != itsMapList.end();
            loop++ ) {
    	if	( *loop == aN )	return *loop;
    }
    CFurserSrLevl dummy;
    return dummy;
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::SetMap		( const char * aN, const CFurserSrLevl & aC ) {
	if	( ( ! CFurserSrSrvr::HasMap( aC.MapName() ) ) || ( aC == aN ) ) {
		CFurserSrLevl_li	loop;
    	for	(	loop  = itsMapList.begin();
				loop != itsMapList.end();
            	loop++ ) {
	    	if	( *loop == aN ) {
    	    	*loop = aC;
        	    break;
            }
        }
    }
	CFurserSrSrvr::ReplaceMacro(	"$(GamebChangeLevels)",
    								CFurserSrSrvr::RotateCount() > 1 ? "True" : "False" );
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::AddMap		( const CFurserSrLevl & aC ) {
	if	( ! CFurserSrSrvr::HasMap( aC.MapName() ) ) {
    	itsMapList.push_back( aC );
    }
	CFurserSrSrvr::ReplaceMacro(	"$(GamebChangeLevels)",
    								CFurserSrSrvr::RotateCount() > 1 ? "True" : "False" );
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::DelMap		( const CFurserSrLevl & aC ) {
	itsMapList.remove( aC );
	CFurserSrSrvr::ReplaceMacro(	"$(GamebChangeLevels)",
    								CFurserSrSrvr::RotateCount() > 1 ? "True" : "False" );
}

// --------------------------------------------------------------------
bool	CFurserSrSrvr::HasMacro		( const char * aN ) const {
	CFurserSrMacr_lci	loop;
    for	(	loop  = itsMacroList.begin();
    		loop != itsMacroList.end();
            loop++ ) {
    	if	( *loop == aN )	return true;
    }
    return false;
}

// --------------------------------------------------------------------
CFurserSrMacr	CFurserSrSrvr::GetMacro		( const char * aN ) const {
	CFurserSrMacr_lci	loop;
    for	(	loop  = itsMacroList.begin();
    		loop != itsMacroList.end();
            loop++ ) {
    	if	( *loop == aN )	return *loop;
    }
    CFurserSrMacr dummy;
    return dummy;
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::SetMacro		( const char * aN, const CFurserSrMacr & aC ) {
	if	( ( ! CFurserSrSrvr::HasMacro( aC.MacroName() ) ) || ( aC == aN ) ) {
		CFurserSrMacr_li	loop;
    	for	(	loop  = itsMacroList.begin();
				loop != itsMacroList.end();
            	loop++ ) {
	    	if	( *loop == aN ) {
    	    	*loop = aC;
        	    break;
            }
        }
    }
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::AddMacro		( const CFurserSrMacr & aC ) {
	if	( ! CFurserSrSrvr::HasMacro( aC.MacroName() ) ) {
    	itsMacroList.push_back( aC );
    }
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::DelMacro		( const CFurserSrMacr & aC ) {
	itsMacroList.remove( aC );
}

// --------------------------------------------------------------------
bool	CFurserSrSrvr::Running			( void ) const {
	return itsRunning;
}

// --------------------------------------------------------------------
bool	CFurserSrSrvr::GameRunning			( void ) const {
	return itsGameRunning;
}

// --------------------------------------------------------------------
int		CFurserSrSrvr::ServerType		( void ) const {
	return itsServerType;
}

// --------------------------------------------------------------------
const char *	CFurserSrSrvr::ServerName	( void ) const {
	return itsServerName ? itsServerName : "";
}

// --------------------------------------------------------------------
const char *	CFurserSrSrvr::GameRoot		( void ) const {
	return itsGameRoot ? itsGameRoot : "";
}

// --------------------------------------------------------------------
const char *	CFurserSrSrvr::ExtraUccFlags	( void ) const {
	return itsExtraUccFlags ? itsExtraUccFlags : "";
}

// --------------------------------------------------------------------
bool	CFurserSrSrvr::UsesAdminName	( void ) const {
	return itsUsesAdminName;
}

// --------------------------------------------------------------------
const char *	CFurserSrSrvr::AdminName	( void ) const {
	return itsAdminName ? itsAdminName : "";
}

// --------------------------------------------------------------------
const char *	CFurserSrSrvr::AdminPass	( void ) const {
	return itsAdminPass ? itsAdminPass : "";
}

// --------------------------------------------------------------------
bool	CFurserSrSrvr::UsesGamePass	( void ) const {
	return itsUsesGamePass;
}

// --------------------------------------------------------------------
const char *	CFurserSrSrvr::GamePass		( void ) const {
	return itsGamePass ? itsGamePass : "";
}

// --------------------------------------------------------------------
bool	CFurserSrSrvr::UsesWebAdmin	( void ) const {
	return itsUsesWebAdmin;
}

// --------------------------------------------------------------------
unsigned short	CFurserSrSrvr::WebAdminPort	( void ) const {
	return itsWebAdminPort;
}

// --------------------------------------------------------------------
const CFurserSrSetn_l &	CFurserSrSrvr::SettingList	( void ) const {
	return itsSettingList;
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::SettingList	( const CFurserSrSetn_l & aV ) {
	itsSettingList = aV;
}

// --------------------------------------------------------------------
const CFurserSrEvnt_l &	CFurserSrSrvr::EventList	( void ) const {
	return itsEventList;
}

// --------------------------------------------------------------------
const CFurserSrGrup_l &	CFurserSrSrvr::GroupList	( void ) const {
	return itsGroupList;
}

// --------------------------------------------------------------------
const CFurserSrUser_l &	CFurserSrSrvr::UserList		( void ) const {
	return itsUserList;
}

// --------------------------------------------------------------------
const CFurserSrUban_l &	CFurserSrSrvr::BanList		( void ) const {
	return itsBanList;
}

// --------------------------------------------------------------------
const CFurserSrMuta_l &	CFurserSrSrvr::MutatorList	( void ) const {
	return itsMutatorList;
}

// --------------------------------------------------------------------
const CFurserSrGame_l &	CFurserSrSrvr::GameList		( void ) const {
	return itsGameList;
}

// --------------------------------------------------------------------
const CFurserSrLevl_l &	CFurserSrSrvr::MapList		( void ) const {
	return itsMapList;
}

// --------------------------------------------------------------------
const CFurserSrMacr_l &	CFurserSrSrvr::MacroList	( void ) const {
	return itsMacroList;
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::MacroList	( const CFurserWizQery_l & aL ) {
	CFurserWizQery_lci	loop;
    itsMacroList.clear();
    for	( loop = aL.begin(); loop != aL.end(); loop++ ) {
    	CFurserSrMacr	macr;
        macr.MacroName	( (*loop).Replaces() );
        macr.MacroValue	( (*loop).Value() );
        itsMacroList.push_back( macr );
    }
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::Running		( bool aV ) {
	itsRunning = aV;
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::GameRunning	( bool aV ) {
	itsGameRunning = aV;
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::ServerType	( int aV ) {
	itsServerType = aV;
	switch	( aV ) {
    	case	0:	CFurserSrSrvr::ReplaceMacro( "$(CFurserSrSrvr.ServerType)",  "UT" );		break;
        case	1:	CFurserSrSrvr::ReplaceMacro( "$(CFurserSrSrvr.ServerType)",  "UT2003" );	break;
    }
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::ServerName	( const char * aV ) {
	if	( itsServerName != aV ) {
		if	( itsServerName ) delete [] itsServerName;
		itsServerName = ::my_private_strdup( aV );
    }
    CFurserSrSrvr::ReplaceMacro( "$(CFurserSrSrvr.ServerName)", aV ? aV : "" );
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::GameRoot		( const char * aV ) {
	if	( itsGameRoot != aV ) {
		if	( itsGameRoot ) delete [] itsGameRoot;
		itsGameRoot = ::my_private_strdup( aV );
    }
    CFurserSrSrvr::ReplaceMacro( "$(CFurserSrSrvr.GameRoot)", aV ? aV : "" );
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::ExtraUccFlags	( const char * aV ) {
	if	( itsExtraUccFlags != aV ) {
		if	( itsExtraUccFlags ) delete [] itsExtraUccFlags;
		itsExtraUccFlags = ::my_private_strdup( aV );
    }
    CFurserSrSrvr::ReplaceMacro( "$(CFurserSrSrvr.ExtraUccFlags)", aV ? aV : "" );
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::UsesAdminName	( bool aV ) {
	itsUsesAdminName = aV;
    CFurserSrSrvr::ReplaceMacro( "$(CFurserSrSrvr.UsesAdminName)", aV );
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::AdminName	( const char * aV ) {
	if	( itsAdminName != aV ) {
		if	( itsAdminName ) delete [] itsAdminName;
		itsAdminName = ::my_private_strdup( aV );
    }
    CFurserSrSrvr::ReplaceMacro( "$(CFurserSrSrvr.AdminName)", aV ? aV : "" );
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::AdminPass	( const char * aV ) {
	if	( itsAdminPass != aV ) {
		if	( itsAdminPass ) delete [] itsAdminPass;
		itsAdminPass = ::my_private_strdup( aV );
    }
    CFurserSrSrvr::ReplaceMacro( "$(CFurserSrSrvr.AdminPass)", aV ? aV : "" );
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::UsesGamePass	( bool aV ) {
	itsUsesGamePass = aV;
    CFurserSrSrvr::ReplaceMacro( "$(CFurserSrSrvr.UsesGamePass)", aV );
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::GamePass		( const char * aV ) {
	if	( itsGamePass != aV ) {
		if	( itsGamePass ) delete [] itsGamePass;
		itsGamePass = ::my_private_strdup( aV );
    }
    CFurserSrSrvr::ReplaceMacro( "$(CFurserSrSrvr.GamePass)", aV ? aV : "" );
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::UsesWebAdmin	( bool aV ) {
	itsUsesWebAdmin = aV;
    CFurserSrSrvr::ReplaceMacro( "$(CFurserSrSrvr.UsesWebAdmin)", aV );
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::WebAdminPort	( unsigned short aV ) {
	itsWebAdminPort = aV;
    CFurserSrSrvr::ReplaceMacro( "$(CFurserSrSrvr.WebAdminPort)", (int)aV );
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::ReplaceMacro	( const char * aName, const char * aValue ) {
	if	( CFurserSrSrvr::HasMacro( aName ) ) {
		CFurserSrMacr_li	loop;
    	for	(	loop  = itsMacroList.begin();
				loop != itsMacroList.end();
            	loop++ ) {
	    	if	( *loop == aName ) {
    	    	(*loop).MacroValue( aValue );
        	    break;
            }
        }
    }
    else {
		CFurserSrMacr	macr;
    	macr.MacroName( aName );
	    macr.MacroValue( aValue );
		itsMacroList.push_back( macr );
    }
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::ReplaceMacro	( const char * aName, int aValue ) {
	char	numb[32];
    ::sprintf( numb, "%i", aValue );
	CFurserSrSrvr::ReplaceMacro( aName, numb );
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::ReplaceMacro	( const char * aName, bool aValue ) {
	CFurserSrSrvr::ReplaceMacro( aName, aValue ? "True" : "False" );
}

// --------------------------------------------------------------------
CFurserString_l	CFurserSrSrvr::ListConfigFiles	( void ) const {
	CFurserString_l		filelist;

    // Begin with the ini macro
	filelist.clear();
	if	( CFurserSrSrvr::HasMacro( "$(Ini)" ) ) {
    	filelist.push_back( CFurserSrSrvr::GetMacro( "$(Ini)" ).MacroValue() );
    }

    // Then each part separately
    CFurserSrSrvr::SetnConfigFiles( itsSettingList, filelist );
    CFurserSrSrvr::MutaConfigFiles( filelist );
    CFurserSrSrvr::GameConfigFiles( filelist );

    return	filelist;
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::MutaConfigFiles	( CFurserString_l & aL ) const {
    CFurserSrMuta_lci	muta;
    for	( muta = itsMutatorList.begin(); muta != itsMutatorList.end(); muta++ ) {
        CFurserSrSrvr::SetnConfigFiles( (*muta).SettingList(), aL );
    }
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::GameConfigFiles	( CFurserString_l & aL ) const {
    CFurserSrGame_lci	game;
    for	( game = itsGameList.begin(); game != itsGameList.end(); game++ ) {
        CFurserSrSrvr::SetnConfigFiles( (*game).SettingList(), aL );
    }
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::SetnConfigFiles	( const CFurserSrSetn_l & aS, CFurserString_l & aL ) const {
    CFurserSrSetn_lci	loop;
    for	( loop = aS.begin(); loop != aS.end(); loop++ ) {
		CFurserSrSrvr::ListConfigFile( aL, (*loop).IniFileName() );
    }
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::ListConfigFile	( CFurserString_l & aL, const char * aN ) const {
	char				name	[2048];
	CFurserString_lci	loop;

   	::my_strfit( name, sizeof( name ), aN );
	CFurserSrSrvr::ExpandMacros( name, sizeof( name ) );
	for	( loop = aL.begin(); loop != aL.end(); loop++ ) {
    	if	( *loop == name ) break;
    }
    if	( loop == aL.end() ) {
    	aL.push_back( name );
    }
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::CreateMainIniFile( const char * aPath, char aPathSep, const char * aFile ) const {
	char			path	[1024];
	CWinIniFile		ini;

	// Each portion will be added separately
    CFurserSrSrvr::CreateSetnIniFile( ini, itsSettingList, aFile );
    CFurserSrSrvr::CreateMutaIniFile( ini, aFile );
    CFurserSrSrvr::CreateGameIniFile( ini, aFile );
    if		( itsServerType == 0 ) {
	    CFurserSrSrvr::CreateMapRota1999( ini );
    }
    else if	( itsServerType == 1 ) {
	    CFurserSrSrvr::CreateMapRota2003( ini );
    }

   	// Config file full pathname
   	::sprintf( path, "%s%c%s", aPath, aPathSep, aFile );
    ::unlink( path );
    ini.Write( path );
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::CreateOthrIniFile( const char * aPath, char aPathSep, const char * aFile ) const {
	char			path	[1024];
	CWinIniFile		ini;

	// Each portion will be added separately
    CFurserSrSrvr::CreateSetnIniFile( ini, itsSettingList, aFile );
    CFurserSrSrvr::CreateMutaIniFile( ini, aFile );
    CFurserSrSrvr::CreateGameIniFile( ini, aFile );

   	// Config file full pathname
   	::sprintf( path, "%s%c%s", aPath, aPathSep, aFile );
    ::unlink( path );
    ini.Write( path );
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::CreateAuthIniFile( const char * aPath, char aPathSep ) const {
	char				buffer	[2048];
	char				path	[1024];
    CFurserSrUser_lci	user;
    CFurserSrGrup_lci	grup;
	CWinIniFile			ini;

	// Rewrite the authorization file XAdmin.ini
    if	( itsServerType > 0 ) {
    	for	( user = itsUserList.begin(); user != itsUserList.end(); user++ ) {
			if	( (*user).Enabled() ) {
	   	        ini.Insert( "XAdmin.xAdminConfigIni", "AdminUsers", (*user).IniString( buffer, sizeof( buffer ) ) );
    	    }
	    }
    	for	( grup = itsGroupList.begin(); grup != itsGroupList.end(); grup++ ) {
			if	( (*user).Enabled() ) {
	   	        ini.Insert( "XAdmin.xAdminConfigIni", "AdminGroups", (*grup).IniString( buffer, sizeof( buffer ) ) );
    	    }
	    }
   		::sprintf( path, "%s%c%s", aPath, aPathSep, "XAdmin.ini" );
	    ::unlink( path );
    	ini.Write( path );
    }
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::CreateMutaIniFile	( CWinIniFile & aIni, const char * aFile ) const {
	CFurserSrMuta_lci	loop;
	for	( loop = itsMutatorList.begin(); loop != itsMutatorList.end(); loop++ ) {
		CFurserSrSrvr::CreateSetnIniFile( aIni, (*loop).SettingList(), aFile );
	}
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::CreateGameIniFile	( CWinIniFile & aIni, const char * aFile ) const {
	CFurserSrGame_lci	loop;
	for	( loop = itsGameList.begin(); loop != itsGameList.end(); loop++ ) {
		CFurserSrSrvr::CreateSetnIniFile( aIni, (*loop).SettingList(), aFile );
	}
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::CreateSetnIniFile	( CWinIniFile & aIni, const CFurserSrSetn_l & aSl, const char * aFile ) const {
	CFurserSrSetn_lci	loop;
	char				buffer	[1024];

	for	( loop = aSl.begin(); loop != aSl.end(); loop++ ) {
		::my_strfit( buffer, sizeof( buffer ), (*loop).IniFileName() );
		CFurserSrSrvr::ExpandMacros( buffer, sizeof( buffer ) );
		if	( ::strcmp( aFile, buffer ) )	continue;

		::my_strfit( buffer, sizeof( buffer ), (*loop).SettingValu() );
		CFurserSrSrvr::ExpandMacros( buffer, sizeof( buffer ) );

		if	( ! (*loop).NoReplacing() ) {
			aIni.Delete( (*loop).IniSectName(), (*loop).IniItemName() );
		}
		aIni.Insert( (*loop).IniSectName(), (*loop).IniItemName(), buffer );
	}
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::CreateMapRota1999	( CWinIniFile &  ) const {
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::CreateMapRota2003	( CWinIniFile & aIni ) const {
	char				buffer	[1024];
	CFurserSrGame_lci	game;
	CFurserSrLevl_lci	levl;
	const char *		mapn;
    int *				mapnum;
    int					rotnum;
    int                 games = itsGameList.size();
    int					gix;

	if	( ! games )	throw	CError( "No game types to process" );
    mapnum = new int [games];
    for	( gix = 0; gix < games; gix++ ) mapnum[gix] = -1;

    rotnum = 0;
	for	( levl = itsMapList.begin(); levl != itsMapList.end(); levl++ ) {
		if	( !(*levl).Rotate() )	continue;
		mapn = (*levl).MapName();
		if	( *mapn == '[' ) {
			while ( ( *mapn ) && ( *mapn != ' ' ) )	mapn++;
			if	( *mapn != ' ' )	continue;
			mapn++;
        }
		for	( game = itsGameList.begin(), gix = 0; game != itsGameList.end(); game++, gix++ ) {
			::strcpy( buffer, mapn );
    	    ::strcat( buffer, "?game=" );
    	    ::strcat( buffer, (*levl).GameClass() );
			aIni.Insert( (*game).MapList(), "Maps", buffer );
			if	( *game == (*levl).GameClass() ) {
            	if	( mapnum[gix] < 0 )	mapnum[gix] = rotnum;
            }
        }
		rotnum++;
    }

	for	( game = itsGameList.begin(), gix = 0; game != itsGameList.end(); game++, gix++ ) {
    	::sprintf( buffer, "%i", mapnum[gix] < 0 ? 0 : mapnum[gix] );
		aIni.Insert( (*game).MapList(), "MapNum", buffer );
	}
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::Free		( void ) {
	if	( itsServerName )		delete [] itsServerName;
	if	( itsGameRoot )			delete [] itsGameRoot;
	if	( itsExtraUccFlags )	delete [] itsExtraUccFlags;
	if	( itsAdminName )		delete [] itsAdminName;
	if	( itsAdminPass )		delete [] itsAdminPass;
	if	( itsGamePass )			delete [] itsGamePass;
	CFurserSrSrvr::Cleanup();
}

// --------------------------------------------------------------------
void	CFurserSrSrvr::Cleanup	( void ) {
	itsRunning			= false;
    itsGameRunning		= false;
	itsServerType		= 0;
	itsServerName		= NULL;
	itsGameRoot			= NULL;
	itsExtraUccFlags	= NULL;
	itsUsesAdminName	= false;
	itsAdminName		= NULL;
	itsAdminPass		= NULL;
	itsUsesGamePass		= false;
	itsGamePass			= NULL;
	itsUsesWebAdmin		= false;
	itsWebAdminPort		= 0;
	itsSettingList.clear();
	itsEventList.clear();
	itsGroupList.clear();
	itsUserList.clear();
	itsBanList.clear();
	itsMutatorList.clear();
	itsGameList.clear();
	itsMapList.clear();
	itsMacroList.clear();
}

// --------------------------------------------------------------------
// EOF:	CFurserSrSrvr.cpp
// --------------------------------------------------------------------
