// --------------------------------------------------------------------
// FurserClientThread.cpp
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#include	"FurserDaemon.h"
#include	"CTcpSocket.hxx"
#include	"CError.hxx"

//---------------------------------------------------------------------------
// The process
//---------------------------------------------------------------------------
extern	void	FurserClientThread	( void * aSock ) {
	CTcpSocket *	client = (CTcpSocket *)aSock;

	::FurserLog( "THREAD+", "FurserClientThread" );
	::FurserLock();
	FurserStatus.running++;
	FurserStatus.clients++;
	::FurserUnlock();
	try	{
		CFurserClient	fclient( client, FurserConfig.serverpass );

		// Loop waiting and executing commands here
        while	( FurserStatus.abort == false ) {
        	try	{
				switch	( fclient.ReadCommand( FurserStatus.abort ) ) {
					case	'L':	// Client wants to load my server data
        	        ::FurserServerSendSettings( fclient );
					break;

					case	'S':	// Client wants to save server settings
    	            ::FurserServerRecvSettings( fclient );
					break;

	                case	'r':	// Client wants a scheduler to be run
    	            ::FurserServerStartScheduler( fclient );
        	        break;

	                case	's':	// Client wants a scheduler to stop
    	            ::FurserServerStopScheduler( fclient );
        	        break;

	                case	'g':	// Client wants to see my log file
    	            ::FurserServerSendLogFile( fclient );
        	        break;

	                case	'1':	// Immediately start game server
    	            ::FurserServerImmediateStart( fclient );
        	        break;

	                case	'2':	// Immediately stop game server
    	            ::FurserServerImmediateStop( fclient );
        	        break;

    	    	}
            }
            catch	( CError e ) {
            	::FurserLog( fclient.Address(), e.Error() );
            	::FurserLog( "CLIENT-", fclient.Address() );
                throw;
            }
            catch	( ... ) {
            	::FurserLog( fclient.Address(), "Unknown error" );
            	::FurserLog( "CLIENT-", fclient.Address() );
                throw;
            }
        }
    }
    catch ( ... ) {
    }
	::FurserLog( "THREAD-", "FurserClientThread" );
	::FurserLock();
	FurserStatus.clients--;
	FurserStatus.running--;
	::FurserUnlock();
}

// --------------------------------------------------------------------
// EOF: FurserClientThread.cpp
// --------------------------------------------------------------------
