// --------------------------------------------------------------------
// FurserDaemonServer.cpp
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#include	"FurserDaemon.h"
#include	"CFurserSrData.h"

//---------------------------------------------------------------------------
// Load server data as needed
//---------------------------------------------------------------------------
extern	void	FurserLoadServerData( void ) {
	struct stat	mystat;

	if	( ! ::stat( FurserConfig.serverfile, &mystat ) ) {
		if	( ( FurserIniTime == 0 ) || ( FurserIniTime < mystat.st_mtime ) ) {
			::FurserLock();
			try	{
				FurserIni.Clear();
		    	FurserIni.Read( FurserConfig.serverfile );
				FurserIniTime = mystat.st_mtime;
				::FurserUnlock();
			}
			catch ( ... ) {
				FurserIni.Clear();
				::FurserUnlock();
			}
		}
	}
}

//---------------------------------------------------------------------------
// Send server settings to client
//---------------------------------------------------------------------------
extern void	FurserServerSendSettings ( CFurserClient & aClient ) {
	CFurserSrData	mydata;
	::FurserLog( aClient.Address(), "Send settings" );
	if	( ! FurserStatus.error ) {
		::FurserLoadServerData();
		::FurserLock();
		try {
	    	mydata.Load( FurserIni );
			::FurserUnlock();
        }
		catch	( ... ) {
			::FurserUnlock();
        	throw;
        }
		::FurserScanRunningServers( mydata );
		mydata.Save( aClient );
	}
	else {
		throw CError( FurserStatus.error );
	}
}

//---------------------------------------------------------------------------
// Receive server settings from client
//---------------------------------------------------------------------------
extern void	FurserServerRecvSettings ( CFurserClient & aClient ) {
	CFurserSrData	mydata;
	::FurserLog( aClient.Address(), "Receive settings" );
	if	( ! FurserStatus.error ) {
    	mydata.Load( aClient );
		::FurserLock();
		try {
			mydata.Save( FurserConfig.serverfile );
			::FurserLoadServerData();
			::FurserUnlock();
        }
		catch	( ... ) {
			::FurserUnlock();
        	throw;
        }
	}
	else {
		throw CError( FurserStatus.error );
	}
}

//---------------------------------------------------------------------------
// Client wants to run a scheduler
//---------------------------------------------------------------------------
extern void	FurserServerStartScheduler( CFurserClient & aClient ) {
	CFurserSrData	mydata;
	char *			srvname;
	::FurserLog( aClient.Address(), "Start scheduler" );
	if	( ! FurserStatus.error ) {
		::FurserLoadServerData();
		::FurserLock();
		try {
	    	mydata.Load( FurserIni );
			::FurserUnlock();
        }
		catch	( ... ) {
			::FurserUnlock();
        	throw;
        }
    	srvname = aClient.RxData();
   		mydata.NetStart( aClient, srvname, false );
		delete [] srvname;
		::FurserLock();
		try {
			mydata.Save( FurserConfig.serverfile );
			::FurserLoadServerData();
			::FurserUnlock();
        }
		catch	( ... ) {
			::FurserUnlock();
        	throw;
        }
	}
	else {
		throw CError( FurserStatus.error );
	}
}

//---------------------------------------------------------------------------
// Client wants to stop a server
//---------------------------------------------------------------------------
extern void	FurserServerStopScheduler( CFurserClient & aClient ) {
	CFurserSrData	mydata;
	char *			srvname;
	::FurserLog( aClient.Address(), "Stop scheduler" );
	if	( ! FurserStatus.error ) {
		::FurserLoadServerData();
		::FurserLock();
		try {
	    	mydata.Load( FurserIni );
			::FurserUnlock();
        }
		catch	( ... ) {
			::FurserUnlock();
        	throw;
        }
    	srvname = aClient.RxData();
   		mydata.NetStop( aClient, srvname, false );
		delete [] srvname;
		::FurserLock();
		try {
			mydata.Save( FurserConfig.serverfile );
			::FurserLoadServerData();
			::FurserUnlock();
        }
		catch	( ... ) {
			::FurserUnlock();
        	throw;
        }
	}
	else {
		throw CError( FurserStatus.error );
	}
}

//---------------------------------------------------------------------------
// Client wants to see my log file
//---------------------------------------------------------------------------
extern void	FurserServerSendLogFile( CFurserClient & aClient ) {
	CFurserSrData	mydata;
	FILE *	logstm	= NULL;
    char *	logdat	= NULL;
    long	logsiz;
	::FurserLog( aClient.Address(), "Send log file" );
	if	( ! FurserStatus.error ) {
		try {
			::FurserLock();
            try {
            	logstm = ::fopen( FurserConfig.logfile, "rb" );
                if	( ! logstm )	throw CError( FurserConfig.logfile, ::strerror( errno ) );
				::fseek( logstm, 0L, SEEK_END );
				logsiz = ::ftell( logstm );
                if	( logsiz < 0 )	throw CError( "Invalid size" );
                ::fseek( logstm, 0L, SEEK_SET );
                logdat = new char [logsiz + 1];
                ::memset( logdat, 0, logsiz + 1 );
				::fread( logdat, logsiz, 1, logstm );
				::fclose( logstm );
                logstm = NULL;
            	::FurserUnlock();
            }
            catch ( ... ) {
            	::FurserUnlock();
                throw;
            }
    		mydata.NetLogdata( aClient, logdat, false );
			delete [] logdat;
    	}
    	catch ( ... ) {
        	if	( logdat )	delete [] logdat;
            if	( logstm )	::fclose( logstm );
			throw;
	    }
	}
	else {
		throw CError( FurserStatus.error );
	}
}

// --------------------------------------------------------------------
// EOF: FurserDaemonServer.cpp
// --------------------------------------------------------------------
