// --------------------------------------------------------------------
// FurserGameServer.cpp
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#include	"FurserDaemon.h"
#include	"CError.hxx"

#ifdef	WIN32
//---------------------------------------------------------------------------
// Windows version of starting the game server
//---------------------------------------------------------------------------
extern	void	FurserStartGameServer( CFurserTask & aTask, const CFurserSrSrvr & aSrvr) {
	CFurserSrLevl_lci	rota;
	CFurserSrMuta_lci	muta;
	struct stat			mystat;
    STARTUPINFO			mystartup;
	PROCESS_INFORMATION	myinfo;
	char				sysfolder	[512];	// Game system folder
    char				uccbinary	[512];	// The UCC.exe
    char				cmdline		[2048];	// The command line

	// Set up the original system folder
    ::strcpy( sysfolder, aSrvr.GameRoot() );

    // Set up the target system folder
    if	( aSrvr.HasMacro( "$(DedicatedSystemFolder)" ) ) {
    	::strcat( sysfolder, "\\" );
        ::strcat( sysfolder, aSrvr.GetMacro( "$(DedicatedSystemFolder)" ).MacroValue() );
    }
    else {
		::strcat( sysfolder, "\\System" );
    }

    // Check that this folder exists
    if	( ::stat( sysfolder, &mystat ) ) {
    	throw CError( sysfolder, ::strerror( errno ) );
    }
    // Check that it really is a folder
    if	( (mystat.st_mode & S_IFDIR) == 0 ) {
    	throw CError( sysfolder, "Not a directory" );
	}

	// Set up the path to the UCC binary
    ::strcpy( uccbinary, sysfolder );
    ::strcat( uccbinary, "\\UCC.exe" );

    // Check that it exists
    if	( ::stat( uccbinary, &mystat ) ) {
    	throw CError( uccbinary, ::strerror( errno ) );
    }
    // Check that it really is a folder
    if	( (mystat.st_mode & S_IFREG) == 0 ) {
    	throw CError( uccbinary, "Not an executable file" );
	}

	// Set up the command line
    ::sprintf( cmdline, "\"%s\" server \"", uccbinary );

    // Get a map to start the rotation
	for	(	rota  = aSrvr.MapList().begin();
			rota != aSrvr.MapList().end();
            rota++ ) {
		if	( (*rota).Rotate() ) {
			const char *	m = (*rota).MapName();
            if	( *m == '[' ) {
            	while	( ( *m ) && ( *m != ' ' ) )	m++;
	            if	( *m == ' ' )	m++;
            }
            ::strcat( cmdline, m );
            ::strcat( cmdline, "?game=" );
            ::strcat( cmdline, (*rota).GameClass() );
            break;
        }
    }
    // No maps in rotation - this is bad ...
    if	( rota == aSrvr.MapList().end() ) {
    	throw CError( "No maps to start" );
    }

    // Then we look after the mutators that should load at startup
	for	(	muta  = aSrvr.MutatorList().begin();
			muta != aSrvr.MutatorList().end();
            muta++ ) {
    	if	( (*muta).LoadFlag() ) {
        	if	( ! ::strstr( cmdline, (*muta).MutatorName() ) ) {
		    	if	( ::strstr( cmdline, "?mutator=" ) ) {
					::strcat( cmdline, "," );
        		}
	        	else {
					::strcat( cmdline, "?mutator=" );
	        	}
    	        ::strcat( cmdline, (*muta).MutatorName() );
            }
        }
	}

    // Last the additional commandline arguments
	::strcat( cmdline, "\" " );
    ::strcat( cmdline, aSrvr.ExtraUccFlags() );

    // Macro expansion for the command line
	aSrvr.ExpandMacros( cmdline, sizeof( cmdline ) );

    // Rewrite initialization files
    aSrvr.GameConfigFiles( sysfolder, '\\' );

	// Output stuff to log before doing anything
    ::FurserLog( "SYSFOLDER", sysfolder );
    ::FurserLog( "UCCBINARY", uccbinary );
	::FurserLog( "COMMANDLN", cmdline );

    GetStartupInfo( &mystartup );
    mystartup.lpReserved		= NULL;
    mystartup.lpDesktop			= NULL;
    mystartup.lpTitle			= NULL;
    mystartup.dwFlags			= STARTF_USESHOWWINDOW;
    mystartup.wShowWindow		= SW_HIDE;

	// Finally fire up the server itself
	CreateProcess(	uccbinary,
    				cmdline,
                    NULL, NULL,
                    FALSE,
                    CREATE_DEFAULT_ERROR_MODE | DETACHED_PROCESS | NORMAL_PRIORITY_CLASS,
                    NULL,
                    sysfolder,
                    &mystartup,
                    &myinfo );
    aTask.ProcessInfo( myinfo );
    aTask.UccBinary( uccbinary );
    aTask.SysFolder( sysfolder );
    aTask.CmdLine( cmdline );
    aTask.Running( true );
}

//---------------------------------------------------------------------------
// Windows version of stopping the game server
//---------------------------------------------------------------------------
extern	void	FurserStopGameServer( CFurserTask & aTask ) {
	DWORD	state;
    int		count;
	if	( aTask.Running() ) {
    	count = 0;
		do	{
        	state = STILL_ACTIVE;
			if	( GetExitCodeProcess( aTask.ProcessInfo().hProcess, &state ) ) {
            	if	( state == STILL_ACTIVE ) {
					TerminateProcess( aTask.ProcessInfo().hProcess, 0 );
                    SLEEP( 1000 );
                    count++;
                }
            }
            else {
	        	state = STILL_ACTIVE;
				SLEEP( 1000 );
                count++;
            }
        }	while	( ( state == STILL_ACTIVE ) && ( count < 10 ) );
        aTask.Running( false );
	    ::FurserLog( "TERMINATE GAME SERVER", "Terminated" );
    }
    else {
	    ::FurserLog( "TERMINATE GAME SERVER", "Not running" );
    }
}

//---------------------------------------------------------------------------
extern	void	FurserCheckRunningState( CFurserTask & aTask ) {
	DWORD				state;
    STARTUPINFO			mystartup;
	PROCESS_INFORMATION	myinfo;

	if	( ! aTask.Running() )	return;
	if	( GetExitCodeProcess( aTask.ProcessInfo().hProcess, &state ) ) {
    	if	( state == STILL_ACTIVE )	return;
    }

	// Output stuff to log before doing anything
    ::FurserLog( "RESTART SERVER", aTask.Server() );
    ::FurserLog( "SYSFOLDER", aTask.SysFolder() );
    ::FurserLog( "UCCBINARY", aTask.UccBinary() );
	::FurserLog( "COMMANDLN", aTask.CmdLine() );

    GetStartupInfo( &mystartup );
    mystartup.lpReserved		= NULL;
    mystartup.lpDesktop			= NULL;
    mystartup.lpTitle			= NULL;
    mystartup.dwFlags			= STARTF_USESHOWWINDOW;
    mystartup.wShowWindow		= SW_HIDE;

	CreateProcess(	(char *)aTask.UccBinary(),
    				(char *)aTask.CmdLine(),
                    NULL, NULL,
                    FALSE,
                    CREATE_DEFAULT_ERROR_MODE | DETACHED_PROCESS | NORMAL_PRIORITY_CLASS,
                    NULL,
                    (char *)aTask.SysFolder(),
                    &mystartup,
                    &myinfo );
    aTask.ProcessInfo( myinfo );
}

#else
//---------------------------------------------------------------------------
// Unix version of starting the game server
//---------------------------------------------------------------------------
extern	void	FurserStartGameServer( CFurserTask & aTask, const CFurserSrSrvr & aSrvr) {
}

//---------------------------------------------------------------------------
// Unix version of stopping the game server
//---------------------------------------------------------------------------
extern	void	FurserStopGameServer( CFurserTask & aTask ) {
}
#endif

// --------------------------------------------------------------------
// EOF: FurserGameServer.cpp
// --------------------------------------------------------------------
