// --------------------------------------------------------------------
// FurserLog.cpp
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-DEC-2003     Created this source
// --------------------------------------------------------------------
#include	"FurserDaemon.h"

//---------------------------------------------------------------------------
static	void	__MyTimestamp	( FILE * aOut ) {
	char		tmbuff	[128];
	time_t		mytime	= ::time( NULL );

	::strcpy( tmbuff, ::ctime( &mytime ) );
	::my_strfix( tmbuff );
	::fprintf( aOut, "%s", tmbuff );
}

//---------------------------------------------------------------------------
extern	void	FurserLog	( const char * aS1, const char * aS2 ) {
	FILE *		outf	= NULL;
    struct stat	mystat;
	try	{
		::FurserLock();
        if	( FurserConfig.hasconsole ) {
        	__MyTimestamp( stdout );
            ::printf(	" %s %s\n",
                        aS1 ? aS1 : "",
                        aS2 ? aS2 : "" );
        }
		if		( ::stat( FurserConfig.logfile, &mystat ) ) {
        	outf = ::fopen( FurserConfig.logfile, "w" );
        }
        else if	( mystat.st_size > FurserConfig.maxlogfile ) {
			::unlink( FurserConfig.logfile );
        	outf = ::fopen( FurserConfig.logfile, "w" );
        }
        else {
        	outf = ::fopen( FurserConfig.logfile, "a" );
        }
		if	( ! outf )	throw 1;
       	__MyTimestamp( outf );
        ::fprintf(	outf, " %s %s\n",
                    aS1 ? aS1 : "",
                    aS2 ? aS2 : "" );
		::fclose( outf );
		::FurserUnlock();
	}

	catch	( ... ) {
    	if	( outf )	::fclose( outf );
		::FurserUnlock();
	}

}


// --------------------------------------------------------------------
// EOF: FurserLog.cpp
// --------------------------------------------------------------------
