// --------------------------------------------------------------------
// C3DVertex.hxx
// Whatis:  3D modeling library atom
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 21-OCT-2002     Created this source
// --------------------------------------------------------------------
#ifndef C3DVertex_hxx
#define C3DVertex_hxx
#include	"Platform.hxx"

// --------------------------------------------------------------------
// Declaration of the class
// --------------------------------------------------------------------
class   C3DVertex {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    C3DVertex () {
    	itsX = 0.0;
    	itsY = 0.0;
    	itsZ = 0.0;
    }

    // ----------------------------------------------------------------
    C3DVertex ( double aX, double aY, double aZ ) {
    	itsX = aX;
    	itsY = aY;
    	itsZ = aZ;
    }

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~C3DVertex() {}

    // ----------------------------------------------------------------
    public:     // Copy constructor and assignment operator
    // ----------------------------------------------------------------
	C3DVertex				( const C3DVertex & aVertex ) {
		*this = aVertex;
	}

    // ----------------------------------------------------------------
	C3DVertex & operator = 	( const C3DVertex & aVertex ) {
		itsX = aVertex.X();
		itsY = aVertex.Y();
		itsZ = aVertex.Z();
		return *this;
	}

    // ----------------------------------------------------------------
	C3DVertex & operator = 	( double aV ) {
		itsX = itsY = itsZ = aV;
		return *this;
	}

    // ----------------------------------------------------------------
	public:		// Comparison operators
    // ----------------------------------------------------------------
	bool	operator == ( const C3DVertex & aVertex ) {
		if	( aVertex.X() != itsX )	return false;
		if	( aVertex.Y() != itsY )	return false;
		if	( aVertex.Z() != itsZ )	return false;
		return true;
	}

    // ----------------------------------------------------------------
	bool	operator != ( const C3DVertex & aVertex ) {
		if	( aVertex.X() != itsX )	return true;
		if	( aVertex.Y() != itsY )	return true;
		if	( aVertex.Z() != itsZ )	return true;
		return false;
	}

    // ----------------------------------------------------------------
	bool	operator == ( double aV ) {
		if	( aV != itsX )	return false;
		if	( aV != itsY )	return false;
		if	( aV != itsZ )	return false;
		return true;
	}

    // ----------------------------------------------------------------
	bool	operator != ( double aV ) {
		if	( aV != itsX )	return true;
		if	( aV != itsY )	return true;
		if	( aV != itsZ )	return true;
		return false;
	}

    // ----------------------------------------------------------------
	public:		// Interface
    // ----------------------------------------------------------------
	const char *	T3DParse( 	const char * aKw,
								const char * aS );

    // ----------------------------------------------------------------
    double		X	( void )	const	{ return itsX; }
    double		Y	( void )	const	{ return itsY; }
    double		Z	( void )	const	{ return itsZ; }

	void		X	( double aX )		{ itsX = aX; }
	void		Y	( double aY )		{ itsY = aY; }
	void		Z	( double aZ )		{ itsZ = aZ; }

    // ----------------------------------------------------------------
	private:	// Private helpers
    // ----------------------------------------------------------------
	const char *	T3DParseFloat(	double &		theFloat,
									const char *	aS ) const;


    // ----------------------------------------------------------------
    private:    // Instance data
    // ----------------------------------------------------------------
    double		itsX;
    double		itsY;
    double		itsZ;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class C3DVertex>			C3DVertex_l;
typedef C3DVertex_l::iterator       	C3DVertex_li;
typedef C3DVertex_l::const_iterator		C3DVertex_lci;

#endif  // #ifdef  C3DVertex_hxx
// --------------------------------------------------------------------
// EOF: C3DVertex.hxx
// --------------------------------------------------------------------
