// --------------------------------------------------------------------
// CPicture.hxx
// Whatis:  Picture manipulation class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef CPicture_hxx
#define CPicture_hxx
#include	"CPictureSource.hxx"
#include	"CPictureFilter.hxx"
#include	"CPictureDrawer.hxx"

// --------------------------------------------------------------------
// Declaration of the class
// --------------------------------------------------------------------
class   CPicture {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CPicture () {
    }

    // ----------------------------------------------------------------
    CPicture ( dword_t aW, dword_t aH ) {
    	itsPixmap.Create( aW, aH );
    }

    // ----------------------------------------------------------------
    CPicture ( const CPicturePixmap & aPixmap ) {
    	itsPixmap = aPixmap;
    }

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CPicture() {
    }

    // ----------------------------------------------------------------
    public:     // Copy constructor and assignment operator
    // ----------------------------------------------------------------
	CPicture				( const CPicture & aPicture ) {
		itsPixmap = aPicture.Pixmap();
	}

    // ----------------------------------------------------------------
	CPicture & operator = 	( const CPicture & aPicture ) {
		itsPixmap = aPicture.Pixmap();
		return *this;
	}

    // ----------------------------------------------------------------
	CPicture & operator = 	( const CPicturePixmap & aPixmap ) {
		itsPixmap = aPixmap;
		return *this;
	}

    // ----------------------------------------------------------------
	public:		// Interface
    // ----------------------------------------------------------------
    CPicturePixmap		Pixmap		( void )		const	{ return itsPixmap; }
    CPicturePixmap &	PixmapRef	( void )				{ return itsPixmap; }
    void			Save	( CPictureSource & aS ) const	{ aS.Write( itsPixmap ); }
    void			Load	( CPictureSource & aS ) 		{ itsPixmap = aS.Read(); }
    void			Filter	( CPictureFilter & aF )			{ aF.Process( itsPixmap ); }
    void			Draw	( dword_t aX, dword_t aY,
    						  CPictureDrawer & aF )			{ aF.Draw( aX, aY, itsPixmap ); }
    dword_t			W		( void ) 				const	{ return itsPixmap.W(); }
    dword_t			H		( void ) 				const	{ return itsPixmap.H(); }
    void			Create	( dword_t aW, dword_t aH )		{ itsPixmap.Create( aW, aH ); }
    void			Pixel	( dword_t aX, dword_t aY,
    						  const CPicturePixel & aP )	{ itsPixmap.Pixel( aX, aY, aP ); }
	CPicturePixel	Pixel	( dword_t aX, dword_t aY ) const { return itsPixmap.Pixel( aX, aY ); }

    // ----------------------------------------------------------------
    private:    // Instance data
    // ----------------------------------------------------------------
	CPicturePixmap	itsPixmap;		// The image itself
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CPicture>		CPicture_l;
typedef CPicture_l::iterator        CPicture_li;
typedef CPicture_l::const_iterator  CPicture_lci;

#endif  // #ifdef  CPicture_hxx
// --------------------------------------------------------------------
// EOF: CPicture.hxx
// --------------------------------------------------------------------
