// --------------------------------------------------------------------
// CPictureDrawer.hxx
// Whatis:  Picture manipulation class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef CPictureDrawer_hxx
#define CPictureDrawer_hxx
#include	"CPicturePixmap.hxx"

// --------------------------------------------------------------------
// Declaration of the class - used as interface for image filtering
// --------------------------------------------------------------------
class   CPictureDrawer {

    // ----------------------------------------------------------------
    public:     // Constructor
    // ----------------------------------------------------------------
    CPictureDrawer () {
    }

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
	virtual	~CPictureDrawer() {
	}

    // ----------------------------------------------------------------
    public:		// Copy constructor and assignment operator
    // ----------------------------------------------------------------
	CPictureDrawer				( const CPictureDrawer & aPicture );
	CPictureDrawer & operator = ( const CPictureDrawer & aPicture );

    // ----------------------------------------------------------------
	public:		// Interface, pure virtual methods
    // ----------------------------------------------------------------
	virtual	void			Draw( dword_t, dword_t, CPicturePixmap & )	= 0;
};

#endif  // #ifdef  CPictureDrawer_hxx
// --------------------------------------------------------------------
// EOF: CPictureDrawer.hxx
// --------------------------------------------------------------------
