// --------------------------------------------------------------------
// CPictureDrawerText.hxx
// Whatis:  Draw some text into teh image
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef CPictureDrawerText_hxx
#define CPictureDrawerText_hxx
#include	"CPictureDrawer.hxx"

// --------------------------------------------------------------------
#define	DRAWER_FONT_H	16
#define	DRAWER_FONT_W	9

// --------------------------------------------------------------------
// Declaration of the class - used as interface for image filtering
// --------------------------------------------------------------------
class   CPictureDrawerText : public CPictureDrawer {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CPictureDrawerText ( const char * aText );
    CPictureDrawerText ();

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
	~CPictureDrawerText();

    // ----------------------------------------------------------------
    public:		// Copy constructor and assignment operators
    // ----------------------------------------------------------------
	CPictureDrawerText				( const CPictureDrawerText & );
	CPictureDrawerText & operator = ( const CPictureDrawerText & );
	CPictureDrawerText & operator = ( const char * );

    // ----------------------------------------------------------------
	public:		// Interface, pure virtual methods
    // ----------------------------------------------------------------
	void			Draw	( dword_t, dword_t, CPicturePixmap & );

    // ----------------------------------------------------------------
	public:		// Other interfaces
    // ----------------------------------------------------------------
	const char *	Text	( void ) const { return itsText; }
	void			Text	( const char * aText );
	CPicturePixel	FG		( void ) const { return itsFG; }
	CPicturePixel	BG		( void ) const { return itsBG; }
	void			FG		( const CPicturePixel & aC ) { itsFG = aC; }
	void			BG		( const CPicturePixel & aC ) { itsBG = aC; }
	dword_t			W		( void ) const;
	dword_t			H		( void ) const;

    // ----------------------------------------------------------------
	private:	// Private helpers
    // ----------------------------------------------------------------
    void			Cleanup	( void );
    void			Free	( void );

    // ----------------------------------------------------------------
	private:	// Instance data
    // ----------------------------------------------------------------
	char *			itsText;
	CPicturePixel	itsFG;
	CPicturePixel	itsBG;
};

#endif  // #ifdef  CPictureDrawerText_hxx
// --------------------------------------------------------------------
// EOF: CPictureDrawerText.hxx
// --------------------------------------------------------------------
