// --------------------------------------------------------------------
// CPictureFilterIndexed.hxx
// Whatis:  Quantize the image to limited number of colours
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef CPictureFilterIndexed_hxx
#define CPictureFilterIndexed_hxx
#include	"CPictureFilter.hxx"

// --------------------------------------------------------------------
// Declaration of the class - used as interface for image filtering
// --------------------------------------------------------------------
class   CPictureFilterIndexed : public CPictureFilter {

    // ----------------------------------------------------------------
    public:     // Constructor
    // ----------------------------------------------------------------
    CPictureFilterIndexed () {
		itsColors 	= 0;
		itsImage	= NULL;
		itsPalette	= NULL;    	
    }

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
	~CPictureFilterIndexed() {
		if	( itsPalette )	delete [] itsPalette;
		if	( itsImage )	delete [] itsImage;
	}

    // ----------------------------------------------------------------
    private:	// Copy constructor and assignment operator - illegal to use
    // ----------------------------------------------------------------
	CPictureFilterIndexed				( const CPictureFilterIndexed & aPicture );
	CPictureFilterIndexed & operator =	( const CPictureFilterIndexed & aPicture );

    // ----------------------------------------------------------------
	public:		// Interface, pure virtual methods
    // ----------------------------------------------------------------
	void			Process	( CPicturePixmap & aPixmap );

    // ----------------------------------------------------------------
	public:		// Other interfaces
    // ----------------------------------------------------------------
    word_t			Colors	( void ) const { return itsColors; }
    word_tp			Image	( void ) const { return itsImage; }
    CPicturePixel *	Palette	( void ) const { return itsPalette; }

    // ----------------------------------------------------------------
	private:	// Instance data
    // ----------------------------------------------------------------
	word_t			itsColors;
	word_tp			itsImage;
	CPicturePixel *	itsPalette;
};

#endif  // #ifdef  CPictureFilterIndexed_hxx
// --------------------------------------------------------------------
// EOF: CPictureFilterIndexed.hxx
// --------------------------------------------------------------------
