// --------------------------------------------------------------------
// CPictureFilterScale.hxx
// Whatis:  Quantize the image to limited number of colours
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef CPictureFilterScale_hxx
#define CPictureFilterScale_hxx
#include	"CPictureFilter.hxx"

// --------------------------------------------------------------------
// Declaration of the class - used as interface for image filtering
// --------------------------------------------------------------------
class   CPictureFilterScale : public CPictureFilter {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CPictureFilterScale ( dword_t aW, dword_t aH ) {
		itsH = aH;
		itsW = aW;
    }

    CPictureFilterScale ( ) {
		itsH = 0;
		itsW = 0;
    }

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
	~CPictureFilterScale() {
	}

    // ----------------------------------------------------------------
    private:	// Copy constructor and assignment operator - illegal to use
    // ----------------------------------------------------------------
	CPictureFilterScale				 ( const CPictureFilterScale & aPicture );
	CPictureFilterScale & operator = ( const CPictureFilterScale & aPicture );

    // ----------------------------------------------------------------
	public:		// Interface, pure virtual methods
    // ----------------------------------------------------------------
	void			Process	( CPicturePixmap & aPixmap );

    // ----------------------------------------------------------------
	public:		// Other interfaces
    // ----------------------------------------------------------------
    dword_t			H	( void ) const { return itsH; }
    void			H	( dword_t aH ) { itsH = aH; }
    dword_t			W	( void ) const { return itsW; }
    void			W	( dword_t aW ) { itsW = aW; }

    // ----------------------------------------------------------------
	private:	// Private helpers
    // ----------------------------------------------------------------
	void			WScale	(	CPicturePixmap & aPixmap );
	void			HScale	(	CPicturePixmap & aPixmap );
	void			ScaleUp	(	CPicturePixel *	aT,
								dword_t			aTs,
								CPicturePixel *	aS,
								dword_t			aSs );
	void			ScaleDn	(	CPicturePixel *	aT,
								dword_t			aTs,
								CPicturePixel *	aS,
								dword_t			aSs );

    // ----------------------------------------------------------------
	private:	// Instance data
    // ----------------------------------------------------------------
    dword_t			itsH;
    dword_t			itsW;

};

#endif  // #ifdef  CPictureFilterScale_hxx
// --------------------------------------------------------------------
// EOF: CPictureFilterScale.hxx
// --------------------------------------------------------------------
