// --------------------------------------------------------------------
// CPicturePixel.hxx
// Whatis:  Pixel class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef CPicturePixel_hxx
#define CPicturePixel_hxx
#include	"Platform.hxx"

#ifdef	RGB
#undef	RGB
#endif

// --------------------------------------------------------------------
// Declaration of the class
// --------------------------------------------------------------------
class   CPicturePixel {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CPicturePixel ();
    CPicturePixel ( byte_t aR, byte_t aG, byte_t aB, byte_t aA );
    CPicturePixel ( const char * aCstr );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CPicturePixel();

    // ----------------------------------------------------------------
    public:     // Copy constructor
    // ----------------------------------------------------------------
	CPicturePixel	( const CPicturePixel & aP );

    // ----------------------------------------------------------------
    public:     // Assignment operators
    // ----------------------------------------------------------------
    CPicturePixel & operator = ( const CPicturePixel & aP );
    CPicturePixel & operator = ( const char * aCstr );
    CPicturePixel & operator = ( word_t a565C );

    // ----------------------------------------------------------------
    public:     // Comparison operator
    // ----------------------------------------------------------------
	bool	operator == ( const CPicturePixel & aC ) const;

    // ----------------------------------------------------------------
    public:     // Interface
    // ----------------------------------------------------------------
    byte_t		R	( void ) const 	{ return itsR; }
    byte_t		G	( void ) const 	{ return itsG; }
    byte_t		B	( void ) const 	{ return itsB; }
    byte_t		A	( void ) const 	{ return itsA; }

	void		R	( byte_t aR )	{ itsR = aR; }
	void		R	( const CPicturePixel & aP ) { itsR=aP.R(); }
	void		G	( byte_t aG )	{ itsG = aG; }
	void		G	( const CPicturePixel & aP ) { itsG=aP.G(); }
	void		B	( byte_t aB )	{ itsB = aB; }
	void		B	( const CPicturePixel & aP ) { itsB=aP.B(); }
	void		A	( byte_t aA )	{ itsA = aA; }
	void		A	( const CPicturePixel & aP ) { itsA=aP.A(); }
	void		RGB	( const CPicturePixel & aP ) { itsR=aP.R(); itsG=aP.G(); itsB=aP.B(); }
	void		RGB	( byte_t aR, byte_t aG, byte_t aB ) { itsR=aR; itsG=aG; itsB=aB; }
	void		RGBA( byte_t aR, byte_t aG, byte_t aB, byte_t aA ) { itsR=aR; itsG=aG; itsB=aB; itsA = aA; }

	dword_t		DwPx( void ) const { return itsR + (itsG << 8) + (itsB << 16); }


	word_t			Luminance	( void ) const;
	void			Luminance	( word_t aL );

	CPicturePixel	Interpolate	( 	const CPicturePixel &	aP,
									double					aF ) const;

    // ----------------------------------------------------------------
    private:    // Helpers
    // ----------------------------------------------------------------
    const char *	SetCstr	( byte_t & theC, const char * aStr );
    byte_t			HexValu	( char aC );
	
    // ----------------------------------------------------------------
    private:    // Instance data
    // ----------------------------------------------------------------
	byte_t		itsR;
	byte_t		itsG;
	byte_t		itsB;
	byte_t		itsA;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CPicturePixel>		CPicturePixel_l;
typedef CPicturePixel_l::iterator		CPicturePixel_li;
typedef CPicturePixel_l::const_iterator	CPicturePixel_lci;

#endif  // #ifdef  CPicturePixel_hxx
// --------------------------------------------------------------------
// EOF: CPicturePixel.hxx
// --------------------------------------------------------------------
