// --------------------------------------------------------------------
// CPictureSourceGIF.hxx
// Whatis:  GIF Picture manipulation class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef CPictureSourceGIF_hxx
#define CPictureSourceGIF_hxx
#include	"CPictureSource.hxx"

// --------------------------------------------------------------------
// Declaration of the class - used as interface for image transfers
// --------------------------------------------------------------------
class   CPictureSourceGIF : public CPictureSource {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CPictureSourceGIF ( const char * aGifFile = NULL );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
	~CPictureSourceGIF();

    // ----------------------------------------------------------------
    public:		// Copy constructor and assignment operator
    // ----------------------------------------------------------------
	CPictureSourceGIF				( const CPictureSourceGIF & aPicture );
	CPictureSourceGIF & operator =	( const CPictureSourceGIF & aPicture );

    // ----------------------------------------------------------------
	public:		// Interface
    // ----------------------------------------------------------------
	CPicturePixmap	Read	( void ) const;
	void			Write	( const CPicturePixmap & );

	const char *	File	( void ) const { return itsFile; }
	void			File	( const char * aFile );

    // ----------------------------------------------------------------
    private:    // Private helpers
    // ----------------------------------------------------------------
    void			Result			( int aCode ) const;
	void			Cleanup			( void );
	void			Free			( void );
	void			FreePalette		( void * aPalette );

    // ----------------------------------------------------------------
    private:    // Instance data
    // ----------------------------------------------------------------
    char *			itsFile;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CPictureSourceGIF>		CPictureSourceGIF_l;
typedef CPictureSourceGIF_l::iterator       CPictureSourceGIF_li;
typedef CPictureSourceGIF_l::const_iterator	CPictureSourceGIF_lci;

#endif  // #ifdef  CPictureSourceGIF_hxx
// --------------------------------------------------------------------
// EOF: CPictureSourceGIF.hxx
// --------------------------------------------------------------------
