// --------------------------------------------------------------------
// CPictureSourceJPG.hxx
// Whatis:  JPG Picture manipulation class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef CPictureSourceJPG_hxx
#define CPictureSourceJPG_hxx
#include	"CPictureSource.hxx"

// --------------------------------------------------------------------
// Declaration of the class - used as interface for image transfers
// --------------------------------------------------------------------
class   CPictureSourceJPG : public CPictureSource {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CPictureSourceJPG ( );

    // ----------------------------------------------------------------
    CPictureSourceJPG ( const char * aJpgFile, word_t aQuality = 50 );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
	~CPictureSourceJPG();

    // ----------------------------------------------------------------
    public:		// Copy constructor and assignment operator
    // ----------------------------------------------------------------
	CPictureSourceJPG				( const CPictureSourceJPG & aPicture );
	CPictureSourceJPG & operator =	( const CPictureSourceJPG & aPicture );

    // ----------------------------------------------------------------
	public:		// Interface
    // ----------------------------------------------------------------
	CPicturePixmap	Read	( void ) const;
	void			Write	( const CPicturePixmap & );

	const char *	File	( void ) const { return itsFile; }
	void			File	( const char * aFile );

	word_t			Quality	( void ) const { return itsQuality; }
	void			Quality	( word_t aQ ) { itsQuality = aQ; }

	char *			MemDump	( const CPicturePixmap &, dword_t & aLen );

    // ----------------------------------------------------------------
    private:    // Helpers
    // ----------------------------------------------------------------
	void			Cleanup	( void );
	void			Free	( void );

    // ----------------------------------------------------------------
    private:    // Instance data
    // ----------------------------------------------------------------
    char *			itsFile;
    word_t			itsQuality;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CPictureSourceJPG>		CPictureSourceJPG_l;
typedef CPictureSourceJPG_l::iterator       CPictureSourceJPG_li;
typedef CPictureSourceJPG_l::const_iterator	CPictureSourceJPG_lci;

#endif  // #ifdef  CPictureSourceJPG_hxx
// --------------------------------------------------------------------
// EOF: CPictureSourceJPG.hxx
// --------------------------------------------------------------------
