// --------------------------------------------------------------------
// CPictureSourceUTX.hxx
// Whatis:  UTX Picture manipulation class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef CPictureSourceUTX_hxx
#define CPictureSourceUTX_hxx
#include	"CPictureSource.hxx"
#include	"CUnTexture.hxx"

// --------------------------------------------------------------------
// Declaration of the class - used as interface for image transfers
// --------------------------------------------------------------------
class   CPictureSourceUTX : public CPictureSource {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CPictureSourceUTX ( ) {
		itsTexture = (const CUnTexture *)NULL;
    }

    // ----------------------------------------------------------------
    CPictureSourceUTX ( const CUnTexture * aTexture ) {
		itsTexture = aTexture;
    }

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
	~CPictureSourceUTX() {
	}

    // ----------------------------------------------------------------
    public:	// Copy constructor and assignment operator
    // ----------------------------------------------------------------
	CPictureSourceUTX				( const CPictureSourceUTX & aSource ) {
		itsTexture = aSource.Texture();
	}

    // ----------------------------------------------------------------
	CPictureSourceUTX & operator =	( const CPictureSourceUTX & aSource ) {
		itsTexture = aSource.Texture();
		return *this;
	}

    // ----------------------------------------------------------------
	public:		// Interface
    // ----------------------------------------------------------------
	CPicturePixmap		Read	( void ) const;
	void				Write	( const CPicturePixmap & );

	const CUnTexture *	Texture	( void ) const { return itsTexture; }
	void				Texture ( const CUnTexture * aTexture ) { itsTexture = aTexture; }

    // ----------------------------------------------------------------
    private:    // Instance data
    // ----------------------------------------------------------------
	const CUnTexture *	itsTexture;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CPictureSourceUTX>		CPictureSourceUTX_l;
typedef CPictureSourceUTX_l::iterator       CPictureSourceUTX_li;
typedef CPictureSourceUTX_l::const_iterator	CPictureSourceUTX_lci;

#endif  // #ifdef  CPictureSourceUTX_hxx
// --------------------------------------------------------------------
// EOF: CPictureSourceUTX.hxx
// --------------------------------------------------------------------
