// --------------------------------------------------------------------
// CPolygon.hxx
// Whatis:  3D modeling library atom
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 21-OCT-2002     Created this source
// --------------------------------------------------------------------
#ifndef CPolygon_hxx
#define CPolygon_hxx
#include	"CVertex.hxx"

// --------------------------------------------------------------------
// Declaration of the class
// --------------------------------------------------------------------
class   CPolygon {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CPolygon () {}
    CPolygon ( const const CVertex_l & aVl ) {
    	itsVertexList = aVl;
    }

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CPolygon() {}

    // ----------------------------------------------------------------
    public:     // Copy constructor and assignment operator
    // ----------------------------------------------------------------
	CPolygon				( const CPolygon & aPolygon ) {
		*this = aPolygon;
	}

    // ----------------------------------------------------------------
	CPolygon & operator = 	( const CPolygon & aPolygon ) {
		itsVertexList = aPolygon.VertexList();
		return *this;
	}

    // ----------------------------------------------------------------
	public:		// Interface
    // ----------------------------------------------------------------
    const CVertex_l &	VertexList	( void )	const			{ return itsVertexList; }
    void				VertexList	( const CVertex_l & aVl )	{ itsVertexList = aVl; }
    void				Vertex		( const CVertex & aV )		{ itsVertexList.push_back( aV ); }

    // ----------------------------------------------------------------
    private:    // Instance data
    // ----------------------------------------------------------------
	CVertex_l	itsVertexList;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CPolygon>		CPolygon_l;
typedef CPolygon_l::iterator       	CPolygon_li;
typedef CPolygon_l::const_iterator	CPolygon_lci;

#endif  // #ifdef  CPolygon_hxx
// --------------------------------------------------------------------
// EOF: CPolygon.hxx
// --------------------------------------------------------------------
