// --------------------------------------------------------------------
// CVertex.hxx
// Whatis:  3D modeling library atom
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 21-OCT-2002     Created this source
// --------------------------------------------------------------------
#ifndef CVertex_hxx
#define CVertex_hxx
#include	"Platform.hxx"

// --------------------------------------------------------------------
// Declaration of the class
// --------------------------------------------------------------------
class   CVertex {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CVertex () {
    	itsX = 0.0;
    	itsY = 0.0;
    	itsZ = 0.0;
    }

    // ----------------------------------------------------------------
    CVertex ( double aX, double aY, double aZ ) {
    	itsX = aX;
    	itsY = aY;
    	itsZ = aZ;
    }

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CVertex() {}

    // ----------------------------------------------------------------
    public:     // Copy constructor and assignment operator
    // ----------------------------------------------------------------
	CVertex					( const CVertex & aVertex ) {
		*this = aVertex;
	}

    // ----------------------------------------------------------------
	CVertex & operator = 	( const CVertex & aVertex ) {
		itsX = aVertex.X();
		itsY = aVertex.Y();
		itsZ = aVertex.Z();
		return *this;
	}

    // ----------------------------------------------------------------
	CVertex & operator = 	( double aV ) {
		itsX = itsY = itsZ = aV;
		return *this;
	}

    // ----------------------------------------------------------------
	public:		// Comparison operators
    // ----------------------------------------------------------------
	bool	operator == ( const CVertex & aVertex ) {
		if	( aVertex.X() != itsX )	return false;
		if	( aVertex.Y() != itsY )	return false;
		if	( aVertex.Z() != itsZ )	return false;
		return true;
	}

    // ----------------------------------------------------------------
	bool	operator != ( const CVertex & aVertex ) {
		if	( aVertex.X() != itsX )	return true;
		if	( aVertex.Y() != itsY )	return true;
		if	( aVertex.Z() != itsZ )	return true;
		return false;
	}

    // ----------------------------------------------------------------
	bool	operator == ( double aV ) {
		if	( aV != itsX )	return false;
		if	( aV != itsY )	return false;
		if	( aV != itsZ )	return false;
		return true;
	}

    // ----------------------------------------------------------------
	bool	operator != ( double aV ) {
		if	( aV != itsX )	return true;
		if	( aV != itsY )	return true;
		if	( aV != itsZ )	return true;
		return false;
	}

    // ----------------------------------------------------------------
	public:		// Interface
    // ----------------------------------------------------------------
    double		X	( void )	const	{ return itsX; }
    double		Y	( void )	const	{ return itsY; }
    double		Z	( void )	const	{ return itsZ; }

	void		X	( double aX )		{ itsX = aX; }
	void		Y	( double aY )		{ itsY = aY; }
	void		Z	( double aZ )		{ itsZ = aZ; }

    // ----------------------------------------------------------------
    private:    // Instance data
    // ----------------------------------------------------------------
    double		itsX;
    double		itsY;
    double		itsZ;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CVertex>		CVertex_l;
typedef CVertex_l::iterator       	CVertex_li;
typedef CVertex_l::const_iterator	CVertex_lci;

#endif  // #ifdef  CVertex_hxx
// --------------------------------------------------------------------
// EOF: CVertex.hxx
// --------------------------------------------------------------------
