// --------------------------------------------------------------------
// C3DPolyList.cxx
// Whatis:  3D modeling library atom
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 21-OCT-2002     Created this source
// --------------------------------------------------------------------
#include	"CError.hxx"
#include	"C3DPolyList.hxx"

// --------------------------------------------------------------------
// public:	Parse a string into a polygon (multiple vertexes)
// --------------------------------------------------------------------
void	C3DPolyList::T3DParseFile( const char * aFile ) {

	char *			polytext = NULL;
	const char *	polyptr;

	itsPolyList.clear();

	try	{
		polytext = ::my_load_file( aFile );

		// Find a position that starts with Begin PolyList
		polyptr = ::strstr( polytext, "Begin PolyList" );
		if	( ! polyptr ) {
			throw CError( aFile, "Not a T3D file (no start tag)" );
		}

		// Skip over the start phrase
		polyptr += 14;

		// Do we have the End PolyList as well ?
		if	( ! ::strstr( polyptr, "End PolyList" ) ) {
			throw CError( aFile, "Not a T3D file (no end tag)" );
		}

		// Process until we reach the end phrase
		while	( ::strncmp( polyptr, "End PolyList", 12 ) ) {
			C3DPolygon	polygon;

			// Parse one polygon
			polyptr = polygon.T3DParse( polyptr );

			// Didn't get anything ?
			if	( polygon.VertexList().size() == 0 ) {
				throw CError( aFile, "Not a T3D file (Unknown format)" );
			}

			// Add to our list
			itsPolyList.push_back( polygon );

			// Skip blanks
			while	( ( *polyptr > 0 ) && ( *polyptr <= ' ' ) )	polyptr++;
		}

		delete [] polytext;
	}

	catch	( CError e ) {
		if	( polytext )	delete [] polytext;
		throw CError( "C3DPolyList::T3DParseFile", e.Error() );
	}

	catch	( ... ) {
		if	( polytext )	delete [] polytext;
		throw CError( "C3DPolyList::T3DParseFile", "unknown" );
	}
}

// --------------------------------------------------------------------
// EOF: C3DPolyList.cxx
// --------------------------------------------------------------------
