// --------------------------------------------------------------------
// C3DVertex.cxx
// Whatis:  3D modeling library atom
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 21-OCT-2002     Created this source
// --------------------------------------------------------------------
#include	"C3DVertex.hxx"

// --------------------------------------------------------------------
// local:	Macro myIsDigit( ... )
// --------------------------------------------------------------------
#define	myIsDigit( d )	(((d)>='0')&&((d)<='9'))

// --------------------------------------------------------------------
// public:	Parse a string into a vertex
//			<sp>Vertex<sp>-00079.991081,-00445.940063,+00084.000008
// --------------------------------------------------------------------
const char *	C3DVertex::T3DParse	( const char * aKw, const char * aS ) {
	// Default values
	itsX = itsY = itsZ = 0.0;

	// Skip blanks
	while	( ( *aS > 0 ) && ( *aS <= ' ' ) )	aS++;

	// We must have the word 'Vertex' here
	if	( ::strncmp( aS, aKw, ::strlen( aKw ) ) )	return	aS;

	// Skip the word and the spaces after it
	aS += ::strlen( aKw );
	while	( ( *aS > 0 ) && ( *aS <= ' ' ) )	aS++;

	// Parse the digits one after each other
	aS = C3DVertex::T3DParseFloat( itsX, aS );
	if	( *aS != ',' )	return aS;

	aS = C3DVertex::T3DParseFloat( itsY, aS + 1 );
	if	( *aS != ',' )	return aS;

	return	C3DVertex::T3DParseFloat( itsZ, aS + 1 );
}

// --------------------------------------------------------------------
// private:	Parse a flot
//			-00079.991081
// --------------------------------------------------------------------
const char *	C3DVertex::T3DParseFloat(	double &		theFloat,
											const char *	aS ) const {
	bool	negative	= false;
	dword_t	mantissa	= 0;
	dword_t	divisor		= 0;

	// Default value
	theFloat = 0.0;

	// Skip blanks
	while	( ( *aS > 0 ) && ( *aS <= ' ' ) )	aS++;

	// Sign
	if		( *aS == '-' )	{ negative = true; 	aS++; }
	else if	( *aS == '+' )	{ negative = false;	aS++; }
	else if	( *aS == '.' )	{ divisor = 1;		aS++; }
	else if	( ! myIsDigit( *aS ) )	return aS;

	while	( myIsDigit( *aS ) ) {
		mantissa = mantissa * 10 + (dword_t)((*aS - '0') & 0x0f);
		if	( divisor > 0 )	divisor = divisor * 10;

		aS++;
		if	( ( *aS == '.' ) && ( divisor == 0 ) ) {
			divisor = 1;
			aS++;
		}
	}

	theFloat = (double)mantissa / (double)( divisor > 0 ? divisor : 1 );
	if	( negative )	theFloat = -theFloat;
	return	aS;
}

// --------------------------------------------------------------------
// EOF: C3DVertex.cxx
// --------------------------------------------------------------------
