// --------------------------------------------------------------------
// CPicturePixel.cxx
// Whatis:  Pixmap manipulation
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include	"CPicturePixel.hxx"

// --------------------------------------------------------------------
// public:	Constructors
// --------------------------------------------------------------------
CPicturePixel::CPicturePixel () {
	itsR = itsG = itsB = itsA = 0;
}

// --------------------------------------------------------------------
CPicturePixel::CPicturePixel ( byte_t aR, byte_t aG, byte_t aB, byte_t aA ) {
	itsR = aR;
	itsG = aG;
	itsB = aB;
	itsA = aA;
}

// --------------------------------------------------------------------
CPicturePixel::CPicturePixel ( const char * aCstr ) {
	*this = aCstr;
}

// --------------------------------------------------------------------
// public:	Destructor
// --------------------------------------------------------------------
CPicturePixel::~CPicturePixel() {
}

// --------------------------------------------------------------------
// public:	Copy constructor
// --------------------------------------------------------------------
CPicturePixel::CPicturePixel	( const CPicturePixel & aP ) {
	*this = aP;
}

// --------------------------------------------------------------------
// public:	Assignment operators
// --------------------------------------------------------------------
CPicturePixel & CPicturePixel::operator = ( const CPicturePixel & aP ) {
	itsR	= aP.R();
	itsG	= aP.G();
	itsB	= aP.B();
	itsA	= aP.A();
	return *this;
}

// --------------------------------------------------------------------
CPicturePixel & CPicturePixel::operator = ( word_t a565C ) {
	itsB = (byte_t)( a565C & 0x001f );	a565C >>= 5;
	itsG = (byte_t)( a565C & 0x003f );	a565C >>= 6;
	itsR = (byte_t)( a565C & 0x001f );
	itsR <<= 3;
	itsG <<= 2;
	itsB <<= 3;
	return *this;
}

// --------------------------------------------------------------------
CPicturePixel & CPicturePixel::operator = ( const char * aCstr ) {
	aCstr = SetCstr( itsR, aCstr );
	aCstr = SetCstr( itsG, aCstr );
	aCstr = SetCstr( itsB, aCstr );
	SetCstr( itsA, aCstr );
	return *this;
}

// --------------------------------------------------------------------
// public:	Comparison operator
// --------------------------------------------------------------------
bool	CPicturePixel::operator == ( const CPicturePixel & aP ) const {
	return	(itsR == aP.R()) &&
			(itsG == aP.G()) &&
			(itsB == aP.B()) &&
			(itsA == aP.A());
}

// --------------------------------------------------------------------
// public:	Utilities
// --------------------------------------------------------------------
word_t	CPicturePixel::Luminance	( void ) const {
	return (word_t)((itsR + itsG + itsB) / 3);
}

// --------------------------------------------------------------------
void	CPicturePixel::Luminance	( word_t aL ) {
}

// --------------------------------------------------------------------
CPicturePixel	CPicturePixel::Interpolate	( 	const CPicturePixel &	aP,
												double					aF ) const {
	CPicturePixel	pixel;

	if	( aF < 0.0 )	aF = 0.0;
	if	( aF > 1.0 )	aF = 1.0;

	double	f1	= 2.0 - 2.0 * aF;
	double	f2	= 2.0 * aF;

	double	r	= ( (double)itsR * f1 + (double)aP.R() * f2 ) / 2.0;
	double	g	= ( (double)itsG * f1 + (double)aP.G() * f2 ) / 2.0;
	double	b	= ( (double)itsB * f1 + (double)aP.B() * f2 ) / 2.0;
	double	a	= ( (double)itsA * f1 + (double)aP.A() * f2 ) / 2.0;

	pixel.R( (byte_t)( r + 0.5 ) );
	pixel.G( (byte_t)( g + 0.5 ) );
	pixel.B( (byte_t)( b + 0.5 ) );
	pixel.A( (byte_t)( a + 0.5 ) );

	return	pixel;
}

// --------------------------------------------------------------------
const char *	CPicturePixel::SetCstr	( byte_t & theC, const char * aStr ) {
	theC = 0;

	if	( aStr[0] )	theC = CPicturePixel::HexValu( *(aStr++) );
	if	( aStr[0] ) theC = (byte_t)( (theC << 4) | CPicturePixel::HexValu( *(aStr++) ) );
	return	aStr;
}

// --------------------------------------------------------------------
byte_t	CPicturePixel::HexValu	( char aC ) {
	switch	( aC ) {
		case	'1':
		case	'2':
		case	'3':
		case	'4':
		case	'5':
		case	'6':
		case	'7':
		case	'8':
		case	'9':	return	(byte_t)( aC - '0' );

		case	'A':
		case	'B':
		case	'C':
		case	'D':
		case	'E':
		case	'F':	return	(byte_t)( aC - 'A' + 10 );

		case	'a':
		case	's':
		case	'c':
		case	'd':
		case	'e':
		case	'f':	return	(byte_t)( aC - 'a' + 10 );
	}
	return	0;
}

// --------------------------------------------------------------------
// EOF: CPicturePixel.cxx
// --------------------------------------------------------------------
