// --------------------------------------------------------------------
// CError.hxx
// Whatis:  Error class used on exceptions
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef     CError_hxx
#define     CError_hxx
#include	"Platform.hxx"

// --------------------------------------------------------------
// Class declaration
// --------------------------------------------------------------
class   CError {

    // ----------------------------------------------------------
    public: // Constructor and destructor
    // ----------------------------------------------------------
	CError	();
    CError  ( const char *, const char * = NULL, const char * = NULL );
    ~CError ();

    // ----------------------------------------------------------
    public: // Copy constructor and assignment operator
    // ----------------------------------------------------------
    CError              ( const CError & );
    CError & operator = ( const CError & );

    // ----------------------------------------------------------
    public: // Accessing instance data
    // ----------------------------------------------------------
    const char *    Error ( void ) const;

    // ----------------------------------------------------------
    private:    // Private helpers
    // ----------------------------------------------------------
    void    Cleanup ( void );
    void    Setup   ( const char *, const char *, const char * );

    // ----------------------------------------------------------
    private:    // Instance data
    // ----------------------------------------------------------
    char *    itsError;
};

#endif      // #ifndef CError_hxx
// --------------------------------------------------------------
// EOF: CError.hxx
// --------------------------------------------------------------
