// --------------------------------------------------------------------
// PlatCrypt.cxx
// Whatis:  Encrypt/Decrypt made the simple way
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "Platform.hxx"

// --------------------------------------------------------------------
// local:   Crypt/Decrypt one nibble
// --------------------------------------------------------------------
static  char *  __encryptnibble( char * aB, byte_t aNibble ) {
    switch  ( aNibble & 0x0F ) {
        case    0:      *aB = 'B';  break;
        case    1:      *aB = 'C';  break;
        case    2:      *aB = 'N';  break;
        case    3:      *aB = 'X';  break;
        case    4:      *aB = 'M';  break;
        case    5:      *aB = 'Z';  break;
        case    6:      *aB = 'Y';  break;
        case    7:      *aB = 'T';  break;
        case    8:      *aB = 'U';  break;
        case    9:      *aB = 'R';  break;
        case    10:     *aB = 'I';  break;
        case    11:     *aB = 'E';  break;
        case    12:     *aB = 'O';  break;
        case    13:     *aB = 'W';  break;
        case    14:     *aB = 'P';  break;
        case    15:     *aB = 'Q';  break;
    }
    return  aB + 1;
}

// --------------------------------------------------------------------
static  char *  __decryptnibble( char * aB, byte_t & theNibble ) {
    switch  ( *aB ) {
        case    'B':    theNibble =  0;  break;
        case    'C':    theNibble =  1;  break;
        case    'N':    theNibble =  2;  break;
        case    'X':    theNibble =  3;  break;
        case    'M':    theNibble =  4;  break;
        case    'Z':    theNibble =  5;  break;
        case    'Y':    theNibble =  6;  break;
        case    'T':    theNibble =  7;  break;
        case    'U':    theNibble =  8;  break;
        case    'R':    theNibble =  9;  break;
        case    'I':    theNibble = 10;  break;
        case    'E':    theNibble = 11;  break;
        case    'O':    theNibble = 12;  break;
        case    'W':    theNibble = 13;  break;
        case    'P':    theNibble = 14;  break;
        case    'Q':    theNibble = 15;  break;
        default:        theNibble =  0;  break;
    }
    return  *aB ? aB + 1 : aB;
}

// --------------------------------------------------------------------
// local:   Crypt/Decrypt one byte
// --------------------------------------------------------------------
static  char *  __encryptbyte( char * aB, byte_t aByte ) {
    aB =    __encryptnibble( aB, (byte_t)(aByte / 16) );
    return  __encryptnibble( aB, (byte_t)(aByte % 16) );
}

// --------------------------------------------------------------------
static  char *  __decryptbyte( char *aB, byte_t & theByte ) {
    byte_t  h, l;
    aB = __decryptnibble( aB, h );
    aB = __decryptnibble( aB, l );
    theByte = (byte_t)(16 * h + l);
    return aB;
}

// --------------------------------------------------------------------
// local:   Crypt/Decrypt a word
// --------------------------------------------------------------------
static  char *  __encryptword( char * aB, word_t aWord ) {
    aB =    __encryptbyte( aB, (byte_t)(aWord / 256) );
    return  __encryptbyte( aB, (byte_t)(aWord % 256) );
}

// --------------------------------------------------------------------
static  char *  __decryptword( char * aB, word_t & theWord ) {
    byte_t  h, l;
    aB = __decryptbyte( aB, h );
    aB = __decryptbyte( aB, l );
    theWord = (word_t)(256 * h + l);
    return aB;
}

// --------------------------------------------------------------------
// local:   Crypt/Decrypt a dword
// --------------------------------------------------------------------
static  char *  __encryptdword( char * aB, dword_t aDword ) {
    aB =    __encryptword( aB, (word_t)(aDword / 65536) );
    return  __encryptword( aB, (word_t)(aDword % 65536) );
}

// --------------------------------------------------------------------
static  char *  __decryptdword( char * aB, dword_t & theDword ) {
    word_t  h, l;
    aB = __decryptword( aB, h );
    aB = __decryptword( aB, l );
    theDword = 65536 * h + l;
    return aB;
}

// --------------------------------------------------------------------
// local:   Roll the roller
// --------------------------------------------------------------------
static  dword_t __doroll    ( dword_t aRoll ) {
    bool    bit = (aRoll & 0x80000000) != 0;
    aRoll = aRoll << 1;
    if  ( bit ) aRoll = aRoll | 1;
    return  aRoll;
}

// --------------------------------------------------------------------
// Encrypt
// --------------------------------------------------------------------
extern  char *	my_encrypt  ( char * aB ) {
	if	( aB ) {
	    dword_t roll =   ((dword_t)rand() << 16)
	                   |  (dword_t)rand();
	    char *  copy = ::my_private_strdup( aB );
	    char *  p    = copy;
	
	    // ----------------------------------------------------------------
	    // Write the first character which is always a '@'
	    // ----------------------------------------------------------------
	    *(aB++) = '@';
	    
	    // ----------------------------------------------------------------
	    // Store the roll variable
	    // ----------------------------------------------------------------
	    aB = __encryptdword( aB, roll );
	
	    // ----------------------------------------------------------------
	    // Put the string into the buffer
	    // ----------------------------------------------------------------
	    while   ( *p ) {
	        aB = __encryptbyte( aB, (byte_t)( *p ^ (byte_t)( roll & 0x0f ) ) );
	        roll = __doroll( roll );
	        p++;
	    }
	    delete [] copy;
	}
	return	aB;
}

// --------------------------------------------------------------------
// Decrypt
// --------------------------------------------------------------------
extern	char *	my_decrypt  ( char * aB ) {
	if	( aB ) {
	    if  ( *aB == '@' ) {
		    char *  copy = ::my_private_strdup( aB );
		    char *  r    = copy + 1;
		    dword_t roll;
		
		    // ----------------------------------------------------------------
		    // Retrieve the roller variable
		    // ----------------------------------------------------------------
		    r = __decryptdword( r, roll );
		
		    // ----------------------------------------------------------------
		    // Read the buffer until a zero is met
		    // ----------------------------------------------------------------
		    while   ( *r ) {
		        byte_t  c;
		        r = __decryptbyte( r, c );
		        c = (byte_t)( c ^ (byte_t)( roll & 0x0f ) );
		        roll = __doroll( roll );
		        *(aB++) = c;
		    }
		    *aB = 0;
		    delete [] copy;
		}
	}
	return	aB;
}

// --------------------------------------------------------------------
// EOF: PlatCrypt.cxx
// --------------------------------------------------------------------
