// --------------------------------------------------------------------
// PlatTemp.cxx
// Whatis:  Temporary directory management
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "Platform.hxx"

// --------------------------------------------------------------------
// public:      Create a temporary directory
// --------------------------------------------------------------------
extern  void    my_make_tempdir     ( char * aTempdir, const char * aRoot ) {
#ifdef	WIN32
    struct _stat mystat;     // Used to check if a directory or file is already taken
#else
    struct stat mystat;     // Used to check if a directory or file is already taken
#endif

    do  {
        ::sprintf( aTempdir, "%s/TEMP_%d", aRoot, ::rand() );
#ifdef	WIN32
    }   while   ( ! ::_stat( aTempdir, &mystat ) );
    ::mkdir( aTempdir );
#else
    }   while   ( ! ::stat( aTempdir, &mystat ) );
    ::mkdir( aTempdir, 0775 );
#endif
}

// --------------------------------------------------------------------
// public:      Erase contents of a directory and the directory as well
// --------------------------------------------------------------------
extern  void    my_erase_tempdir    ( const char * aTempdir ) {
#ifdef	WIN32
    struct  _stat    mystat;
#else
    struct  stat    mystat;
#endif

    dir_file_tl list = ::my_private_dir( aTempdir, true );

    for ( dir_file_tli loop = list.begin(); loop != list.end(); loop++ ) {
#ifdef	WIN32
		::_stat( (*loop).name, &mystat );
    	if		( ( mystat.st_mode & _S_IFREG ) != 0 ) {
#else
		::stat( (*loop).name, &mystat );
    	if		( ( mystat.st_mode & __S_IFMT ) == __S_IFREG ) {
#endif
	        ::unlink( (*loop).name );
        }
#ifdef	WIN32
        else if	( ( mystat.st_mode & _S_IFDIR ) != 0 ) {
#else
        else if	( ( mystat.st_mode & __S_IFMT ) == __S_IFDIR ) {
#endif
			::my_erase_tempdir( (*loop).name );
        }
    }
    ::rmdir( aTempdir );
}

// --------------------------------------------------------------------
// EOF: PlatDir.cxx
// --------------------------------------------------------------------
