// --------------------------------------------------------------------
// CUdelXref.h
// Whatis:  Xreferences
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-FEB-2003     Created this source
// --------------------------------------------------------------------
#ifndef CUdelXref_h
#define CUdelXref_h

#include	"CUpString.h"

// --------------------------------------------------------------------
class CUdelXref {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CUdelXref	();
	~CUdelXref	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CUdelXref				( const CUdelXref & );
	CUdelXref & operator =	( const CUdelXref & );

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
    const CUpString &	Name	( void ) const;
    const CUpString_l &	Need	( void ) const;
    bool				Select	( void ) const; 

	// ----------------------------------------------------------------
    void	Name	( const CUpString & );
    void	Need	( const CUpString_l & );
    void	Select	( bool );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
    CUpString		itsName;
    CUpString_l		itsNeed;
    bool			itsSelect;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CUdelXref>		CUdelXref_l;
typedef CUdelXref_l::iterator       CUdelXref_li;
typedef CUdelXref_l::const_iterator	CUdelXref_lci;

#endif
// --------------------------------------------------------------------
// EOF:	CUdelXref.h
// --------------------------------------------------------------------
