// --------------------------------------------------------------------
// CUdelXref.cpp
// Whatis:  Xreferences
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-FEB-2003     Created this source
// --------------------------------------------------------------------
#include	"CUdelXref.h"


// --------------------------------------------------------------------
CUdelXref::CUdelXref	() {
	itsSelect = false;
}

// --------------------------------------------------------------------
CUdelXref::~CUdelXref		() {
}

// --------------------------------------------------------------------
CUdelXref::CUdelXref				( const CUdelXref & aV ) {
	itsName = aV.Name();
    itsNeed = aV.Need();
    itsSelect = aV.Select();
}

// --------------------------------------------------------------------
CUdelXref & CUdelXref::operator =	( const CUdelXref & aV ) {
	itsName = aV.Name();
    itsNeed = aV.Need();
    itsSelect = aV.Select();
    return *this;
}

// --------------------------------------------------------------------
const CUpString &	CUdelXref::Name	( void ) const {
	return itsName;
}

// --------------------------------------------------------------------
const CUpString_l &	CUdelXref::Need	( void ) const {
	return itsNeed;
}

// --------------------------------------------------------------------
bool	CUdelXref::Select	( void ) const {
	return itsSelect;
}

// --------------------------------------------------------------------
void	CUdelXref::Name	( const CUpString & aV ) {
	itsName = aV;
}

// --------------------------------------------------------------------
void	CUdelXref::Need	( const CUpString_l & aV ) {
	itsNeed = aV;
}

// --------------------------------------------------------------------
void	CUdelXref::Select	( bool aV ) {
	itsSelect = aV;
}

// --------------------------------------------------------------------
// EOF:	CUdelXref.cpp
// --------------------------------------------------------------------
