// --------------------------------------------------------------------
// CUpString.cpp
// Whatis:  String manipulator
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-FEB-2003     Created this source
// --------------------------------------------------------------------
#include	"CUpString.h"

// --------------------------------------------------------------------
// public:	Constructor and destructor
// --------------------------------------------------------------------
CUpString::CUpString	() {
	CUpString::Cleanup();
}

// --------------------------------------------------------------------
CUpString::~CUpString	() {
	CUpString::Free();
}

// --------------------------------------------------------------------
// public:	Copy constructor and assignment operator
// --------------------------------------------------------------------
CUpString::CUpString			( const CUpString & aC ) {
	CUpString::Cleanup();
	*this = aC;
}

// --------------------------------------------------------------------
CUpString & CUpString::operator =	( const CUpString & aC ) {
	CUpString::Free();
    CUpString::Value( aC.Value() );
    itsSelect = aC.Select();
	return *this;
}

// --------------------------------------------------------------------
CUpString & CUpString::operator =	( const char * aS ) {
	CUpString::Free();
    CUpString::Value( aS );
	return *this;
}

// --------------------------------------------------------------------
// public:	Comparison operators
// --------------------------------------------------------------------
bool CUpString::operator == ( const CUpString & aC ) const {
	return	::strcmp( CUpString::Value(), aC.Value() ) == 0;
}

// --------------------------------------------------------------------
bool CUpString::operator == ( const char * aS ) const {
	return	::strcmp( CUpString::Value(), aS ? aS : "" ) == 0;
}

// --------------------------------------------------------------------
bool CUpString::operator != ( const CUpString & aC ) const {
	return	::strcmp( CUpString::Value(), aC.Value() ) != 0;
}

// --------------------------------------------------------------------
bool CUpString::operator != ( const char * aS ) const {
	return	::strcmp( CUpString::Value(), aS ? aS : "" ) != 0;
}

// --------------------------------------------------------------------
// public:	Interface for the list management
// --------------------------------------------------------------------
bool			CUpString::ListSelect	( void ) 	const { return itsSelect; }
void			CUpString::ListSelect	( bool aV )		  { itsSelect = aV; }
const char *	CUpString::ListName		( void ) 	const { return CUpString::Value(); }

// --------------------------------------------------------------------
// public:	Streaming
// --------------------------------------------------------------------
void	CUpString::Write	( CWinIniSection & aSec, const char * aItemName ) const {
	CWinIniItem	itm;
    itm.Name( aItemName );
    itm.Value( CUpString::Value() );
    aSec.Insert( itm );
}

// --------------------------------------------------------------------
void	CUpString::Read		( const CWinIniFile & aIni, const char * aSecName, const char * aItemName ) {
	CUpString::Free();
    CUpString::Value( aIni.Value( aSecName, aItemName ) );
}

// --------------------------------------------------------------------
// public:	Accessing instance data
// --------------------------------------------------------------------
const char *	CUpString::Value	( void ) const { return itsValue ? itsValue : ""; }
bool			CUpString::Select	( void ) const { return itsSelect; }

// --------------------------------------------------------------------
void			CUpString::Value	( const char * aV ) {
	CUpString::Free();
	if	( aV == NULL )	return;
    if	( *aV == 0 )	return;
    itsValue = ::my_private_strdup( aV );
}

// --------------------------------------------------------------------
void			CUpString::Select	( bool aV ) {
    itsSelect = aV;
}

// --------------------------------------------------------------------
// private:	Private helpers
// --------------------------------------------------------------------
void	CUpString::Free		( void ) {
	if	( itsValue )	delete [] itsValue;
    CUpString::Cleanup();
}

// --------------------------------------------------------------------
void	CUpString::Cleanup	( void ) {
	itsValue = NULL;
	itsSelect= false;
}

// --------------------------------------------------------------------
// EOF:	CUpString.cpp
// --------------------------------------------------------------------
