// --------------------------------------------------------------------
// CUnImport.hxx
// Whatis:  Unreal Import
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef CUnImport_hxx
#define CUnImport_hxx
#include    "CUnFile.hxx"

// --------------------------------------------------------------------
// Declaration of the CUnImport class
// --------------------------------------------------------------------
class   CUnImport {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CUnImport ( CUnFile & );
    CUnImport ();

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CUnImport();

    // ----------------------------------------------------------------
    public:     // Accessing instance data
    // ----------------------------------------------------------------
    dword_t     ClassPackage    ( void ) const;
    dword_t     ClassName       ( void ) const;
    dword_t     Package         ( void ) const;
    dword_t     ObjectName      ( void ) const;

    // ----------------------------------------------------------------
    private:    // Private helpers
    // ----------------------------------------------------------------
    void        Cleanup( void );

    // ----------------------------------------------------------------
    private:    // Instance data
    // ----------------------------------------------------------------
    dword_t     itsClassPackage;
    dword_t     itsClassName;
    dword_t     itsPackage;
    dword_t     itsObjectName;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef class CUnImport               CUnImport_t;
typedef class CUnImport *             CUnImport_tp;
typedef list <class CUnImport>        CUnImport_tl;
typedef CUnImport_tl::iterator        CUnImport_tli;
typedef CUnImport_tl::const_iterator  CUnImport_tlci;

#endif  // #ifdef  CUnImport_hxx
// --------------------------------------------------------------------
// EOF: CUnImport.hxx
// --------------------------------------------------------------------
