// --------------------------------------------------------------------
// CUnLevelInfo.hxx
// Whatis:  Level info
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef CUnLevelInfo_hxx
#define CUnLevelInfo_hxx
#include    "CUnTexture.hxx"
#include    "CUnProperty.hxx"
#include    "CUnImportTable.hxx"

// --------------------------------------------------------------------
// Declaration of the CUnLevelInfo class
// --------------------------------------------------------------------
class   CUnLevelInfo {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CUnLevelInfo (  CUnFile_t &,
                    const CUnNameTable_t &,
                    const CUnExportTable_t &,
                    const CUnImportTable_t & );

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operator are lethal
                // Therefore they are made private
    // ----------------------------------------------------------------
    CUnLevelInfo              ( const CUnLevelInfo & );
    CUnLevelInfo & operator = ( const CUnLevelInfo & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CUnLevelInfo();

    // ----------------------------------------------------------------
    public:     // Accessing instance data
    // ----------------------------------------------------------------
    const char *    Author      ( void ) const;
    const char *    Title       ( void ) const;
    const char *    EnterText   ( void ) const;
    const char *    IdealPlayers( void ) const;
    const char *	Audio		( void ) const;
	word_t			ShotCount	( void ) const;
    CUnTexture_tp   Screenshot  ( word_t aIx ) const;

    // ----------------------------------------------------------------
    private:    // Private helpers
    // ----------------------------------------------------------------
    void        Cleanup         ( void );
    void		FreeScreenies	( void );
    void        Free            ( void );
    void        SetFileReader   ( CUnFile_t &,
                                  const CUnNameTable_t &,
                                  const CUnExportTable_t &,
                                  const CUnImportTable_t & );
    void        SetMyAuthor         ( CUnProperty_t & );
    void        SetMyAudio         	( CUnProperty_t & );
    void        SetMyTitle          ( CUnProperty_t & );
    void        SetMyEnterText      ( CUnProperty_t & );
    void        SetMyDescription    ( CUnProperty_t & );
    void        SetMyIdealPlayers   ( CUnProperty_t & );
    void        SetMyScreenshot     ( CUnProperty_t &,
                                      CUnFile_t &,
                                      const CUnNameTable_t &,
                                      const CUnExportTable_t &,
									  const CUnImportTable_t & );

	void		SetMyScreenshotSequence	(	CUnFile_t &,
		                                    const CUnNameTable_t &,
		                                    const CUnExportTable_t &,
		                                    const CUnImportTable_t & );

	void		SetMyScreenshotPicture	(	CUnFile_t &,
		                                    const CUnNameTable_t &,
		                                    const CUnExportTable_t &,
		                                    const CUnImportTable_t & );

    // ----------------------------------------------------------------
    private:    // Instance data
    // ----------------------------------------------------------------
    char *          itsAuthor;
    char *          itsTitle;
    char *          itsEnterText;
    char *          itsIdealPlayers;
    char *			itsAudio;
    CUnTexture_tp * itsScreenshot;
	word_t			itsShotCount;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef class CUnLevelInfo               CUnLevelInfo_t;
typedef class CUnLevelInfo *             CUnLevelInfo_tp;

#endif  // #ifdef  CUnLevelInfo_hxx
// --------------------------------------------------------------------
// EOF: CUnLevelInfo.hxx
// --------------------------------------------------------------------
