// --------------------------------------------------------------------
// CUnPlayer.hxx
// Whatis:	Unreal player class
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	11-JAN-2003		Created	this source
// --------------------------------------------------------------------
#ifndef	CUnPlayer_hxx
#define	CUnPlayer_hxx

#include	"UnTypes.hxx"	// Unreal file data	types (Package Flags)

// --------------------------------------------------------------------
// Declaration of the CUnPlayer class
// --------------------------------------------------------------------
class	CUnPlayer	{

	// ----------------------------------------------------------------
	public:		// Constructors
	// ----------------------------------------------------------------
	CUnPlayer	();

	// ----------------------------------------------------------------
	public:		// Destructor
	// ----------------------------------------------------------------
	~CUnPlayer	();

	// ----------------------------------------------------------------
	public:		// Copy	constructor	and	assignment operator
	// ----------------------------------------------------------------
	CUnPlayer				 ( const CUnPlayer & );
	CUnPlayer	& operator = ( const CUnPlayer & );

	// ----------------------------------------------------------------
	public:		// Comparison operators
	// ----------------------------------------------------------------
	bool operator == ( const CUnPlayer & ) const;
	bool operator != ( const CUnPlayer & ) const;

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	const char *	Name	( void )	const;
	word_t			Frags	( void )	const;
	word_t			Ping	( void )	const;
	const char *	Team	( void )	const;
	word_t			Id		( void )	const;
	word_t			StatsId	( void )	const;

	// ----------------------------------------------------------------
	void			Name	( const char * aV );
	void			Frags	( word_t aV );
	void			Ping	( word_t aV );
	void			Team	( const char * aV );
	void			Id		( word_t aV );
	void			StatsId	( word_t aV );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
	void			Cleanup	( void );

	// ----------------------------------------------------------------
	private:	// Instance	data
	// ----------------------------------------------------------------
	char			itsName	[128];
	word_t			itsFrags;
	word_t			itsPing;
	char			itsTeam	[128];
	word_t			itsId;
	word_t			itsStatsId;
};

// --------------------------------------------------------------------
// Derived data	types
// --------------------------------------------------------------------
typedef class CUnPlayer					CUnPlayer_t;
typedef class CUnPlayer *           	CUnPlayer_tp;
typedef list <class CUnPlayer>			CUnPlayer_tl;
typedef CUnPlayer_tl::iterator			CUnPlayer_tli;
typedef CUnPlayer_tl::const_iterator	CUnPlayer_tlci;

#endif	// #ifdef  CUnPlayer_hxx
// --------------------------------------------------------------------
// EOF:	CUnPlayer.hxx
// --------------------------------------------------------------------
