// --------------------------------------------------------------------
// CUnProperty.hxx
// Whatis:  Unreal Property
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef CUnProperty_hxx
#define CUnProperty_hxx
#include    "CUnNameTable.hxx"
#include    "CUnImportTable.hxx"
#include    "CUnExportTable.hxx"

// --------------------------------------------------------------------
// Declaration of the CUnProperty class
// --------------------------------------------------------------------
class   CUnProperty {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CUnProperty (	CUnFile &,
    				const CUnNameTable &,
    				const CUnImportTable &,
    				const CUnExportTable & );
    CUnProperty ();

    // ----------------------------------------------------------------
    public:     // Copy constructor and assignment operator needed
                // because of the dynamic data contents
    // ----------------------------------------------------------------
    CUnProperty              ( const CUnProperty & );
    CUnProperty & operator = ( const CUnProperty & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CUnProperty();

    // ----------------------------------------------------------------
    public:     // Accessing instance data
    // ----------------------------------------------------------------
    dword_t                 Name    ( void ) const;
    dword_t                 Struc   ( void ) const;
    byte_t                  Type    ( void ) const;
    dword_t                 Size    ( void ) const;
    bool                    Array   ( void ) const;
    byte_t                  ArrIdx  ( void ) const;
    const byte_tp           Data    ( void ) const;
    dword_t                 DataLen ( void ) const;

    // ----------------------------------------------------------------
    public:     // Convenience routines for data reading
    // ----------------------------------------------------------------
    void        Rewind      ( void )    { itsReadOffs = 0; }
    bool        GetBool     ( void );
    byte_t      GetByte     ( void );
    word_t      GetWord     ( void );
    dword_t     GetDword    ( void );
    float       GetFloat    ( void );

    // ----------------------------------------------------------------
    private:    // Private helpers
    // ----------------------------------------------------------------
    void        Copy    ( const CUnProperty & );
    void        Free    ( void );
    void        Cleanup ( void );
    void        Store   ( CUnFile &, dword_t );
    void        Store   ( bool );
    void        Store   ( byte_t );
    void        Store   ( dword_t );
    void        Store   ( float );
    void        AddSpace( dword_t );

	void		SetByteProperty		( CUnFile & );
	void		SetIntProperty		( CUnFile & );
	void		SetBoolProperty		( void );
	void		SetFloatProperty	( CUnFile & );
	void		SetObjectProperty	( CUnFile & );
	void		SetStringProperty	( CUnFile & );
	void		SetAsciizProperty	( CUnFile & );
	void		SetStructProperty	( CUnFile &, const CUnNameTable & );
	void		SetArrayProperty	( CUnFile &, const CUnNameTable &, const CUnImportTable &, const CUnExportTable & );

	void		SetUnknownProperty	( const CUnNameTable &, CUnFile & );

    // ----------------------------------------------------------------
    private:    // Instance data
    // ----------------------------------------------------------------
    dword_t         itsName;
    dword_t         itsStruc;
    byte_t          itsType;
    dword_t         itsSize;
    bool            itsArray;
    byte_t          itsArrIdx;
    byte_tp         itsData;
    dword_t         itsDataLen;
    dword_t         itsReadOffs;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef class CUnProperty               CUnProperty_t;
typedef class CUnProperty *             CUnProperty_tp;
typedef list <class CUnProperty>        CUnProperty_tl;
typedef CUnProperty_tl::iterator        CUnProperty_tli;
typedef CUnProperty_tl::const_iterator  CUnProperty_tlci;

#endif  // #ifdef  CUnProperty_hxx
// --------------------------------------------------------------------
// EOF: CUnProperty.hxx
// --------------------------------------------------------------------
