// --------------------------------------------------------------------
// CUnServerInfo.hxx
// Whatis:	Unreal server info browser
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	21-APR-2003		Created	this source
// --------------------------------------------------------------------
#ifndef	CUnServerInfo_hxx
#define	CUnServerInfo_hxx
#include	"Platform.hxx"

// --------------------------------------------------------------------
// Available server types
// --------------------------------------------------------------------
typedef	enum {
	unreal_server_unknown	= 0,
	unreal_server_2003		= 1,
    unreal_server_ut		= 2
}	unreal_server_t;

// --------------------------------------------------------------------
// Declaration of the CUnServerGameInfo class needed in CUnServerInfo
// --------------------------------------------------------------------
class	CUnServerGameInfo	{

	// ----------------------------------------------------------------
	public:		// Constructor
	// ----------------------------------------------------------------
	CUnServerGameInfo	(	const char *	aOption,
							const char *	aValue );

	// ----------------------------------------------------------------
	public:		// Destructor
	// ----------------------------------------------------------------
	~CUnServerGameInfo();

	// ----------------------------------------------------------------
	public:		// Copy	constructor	and	assignment operators are needed
	// ----------------------------------------------------------------
	CUnServerGameInfo				 ( const CUnServerGameInfo & );
	CUnServerGameInfo	& operator = ( const CUnServerGameInfo & );

	// ----------------------------------------------------------------
	public:		// Accessing the instance data
	// ----------------------------------------------------------------
	const char *	Option		( void ) const;
	const char *	Value		( void ) const;

	// ----------------------------------------------------------------
	private:	// Instance	data
	// ----------------------------------------------------------------
	char *			itsOption;
	char *			itsValue;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef class CUnServerGameInfo					CUnServerGameInfo_t;
typedef class CUnServerGameInfo *				CUnServerGameInfo_tp;
typedef list <class CUnServerGameInfo>			CUnServerGameInfo_tl;
typedef CUnServerGameInfo_tl::iterator			CUnServerGameInfo_tli;
typedef CUnServerGameInfo_tl::const_iterator	CUnServerGameInfo_tlci;

// --------------------------------------------------------------------
// Declaration of the CUnServerGameInfo class needed in CUnServerInfo
// --------------------------------------------------------------------
class	CUnServerPlayerInfo	{

	// ----------------------------------------------------------------
	public:		// Constructor
	// ----------------------------------------------------------------
	CUnServerPlayerInfo	(	dword_t			aPlayerId,
							const char *	aPlayerName,
                            const char *	aPlayerMesh,
                            const char *	aPlayerSkin,
                            const char *	aPlayerFace,
							dword_t			aPing,
							int				aScore,
							dword_t			aStatID );

	// ----------------------------------------------------------------
	public:		// Destructor
	// ----------------------------------------------------------------
	~CUnServerPlayerInfo();

	// ----------------------------------------------------------------
	public:		// Copy	constructor	and	assignment operators are needed
	// ----------------------------------------------------------------
	CUnServerPlayerInfo				 ( const CUnServerPlayerInfo & );
	CUnServerPlayerInfo	& operator = ( const CUnServerPlayerInfo & );

	// ----------------------------------------------------------------
	public:		// Accessing the instance data
	// ----------------------------------------------------------------
	dword_t			PlayerId	( void ) const;
	const char *	PlayerName	( void ) const;
	const char *	PlayerMesh	( void ) const;
	const char *	PlayerSkin	( void ) const;
	const char *	PlayerFace	( void ) const;
	dword_t			Ping		( void ) const;
	int				Score		( void ) const;
	dword_t			StatID		( void ) const;

	// ----------------------------------------------------------------
	private:	// Instance	data
	// ----------------------------------------------------------------
	dword_t			itsPlayerId;
	char *			itsPlayerName;
	char *			itsPlayerMesh;
	char *			itsPlayerSkin;
	char *			itsPlayerFace;
	dword_t			itsPing;
	int				itsScore;
	dword_t			itsStatID;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef class CUnServerPlayerInfo				CUnServerPlayerInfo_t;
typedef class CUnServerPlayerInfo *				CUnServerPlayerInfo_tp;
typedef list <class CUnServerPlayerInfo>		CUnServerPlayerInfo_tl;
typedef CUnServerPlayerInfo_tl::iterator		CUnServerPlayerInfo_tli;
typedef CUnServerPlayerInfo_tl::const_iterator	CUnServerPlayerInfo_tlci;

// --------------------------------------------------------------------
// Declaration of the CUnServerInfo class
// --------------------------------------------------------------------
class	CUnServerInfo	{

	// ----------------------------------------------------------------
	public:		// Constructors
	// ----------------------------------------------------------------
	CUnServerInfo	(	const char *	aIpAddress,
						word_t			aQueryPort,
                        unreal_server_t	aType );

	// ----------------------------------------------------------------
	public:		// Destructor
	// ----------------------------------------------------------------
	~CUnServerInfo();

	// ----------------------------------------------------------------
	public:		// Copy	constructor	and	assignment operators are needed
	// ----------------------------------------------------------------
	CUnServerInfo				 ( const CUnServerInfo & );
	CUnServerInfo	& operator = ( const CUnServerInfo & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	void			Refresh		( void );
	void			Poll		( void );

	// ----------------------------------------------------------------
	public:		// Accessing the instance data
	// ----------------------------------------------------------------
    unreal_server_t					Type				( void ) const;
	const char *					IpAddress			( void ) const;
	word_t							GamePort			( void ) const;
	word_t							QueryPort			( void ) const;
	const char *					ServerName			( void ) const;
	const char *					GameMap				( void ) const;
	const char *					MapTitle			( void ) const;
	const char *					GameType			( void ) const;
	word_t							CurrentPlayers		( void ) const;
	word_t							MaximumPlayers		( void ) const;
	const CUnServerGameInfo_tl &	GameInfo			( void ) const;
	const CUnServerPlayerInfo_tl &	PlayerInfo			( void ) const;

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
	void			Free					( void );
	void			Cleanup					( void );
	void			CleanServerInfo			( void );
	void			UT2k3BasicServerInfo	( void );
	void			UT2k3GameInfo			( void );
	void			UT2k3PlayerInfo			( void );
    bool			SendRequest				( char *, size_t, word_t, const char *, size_t );
    dword_t			ParseDword				( char ** );
    char *			ParseString				( char ** );

	void			UTBasicServerInfo		( const char * );
    char *			ParseUtString			( char ** );
	void			AllocNewString			( char **, char ** );

	// ----------------------------------------------------------------
	private:	// Instance	data
	// ----------------------------------------------------------------
    unreal_server_t			itsType;
	char *					itsIpAddress;
	word_t					itsQueryPort;
	word_t					itsGamePort;
	char *					itsServerName;
	char *					itsGameMap;
    char *					itsMapTitle;
	char *					itsGameType;
	word_t					itsCurrentPlayers;
	word_t					itsMaximumPlayers;
	CUnServerGameInfo_tl	itsGameInfo;
	CUnServerPlayerInfo_tl	itsPlayerInfo;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef class CUnServerInfo					CUnServerInfo_t;
typedef class CUnServerInfo *				CUnServerInfo_tp;
typedef list <class CUnServerInfo>			CUnServerInfo_tl;
typedef CUnServerInfo_tl::iterator			CUnServerInfo_tli;
typedef CUnServerInfo_tl::const_iterator	CUnServerInfo_tlci;

#endif	// #ifdef  CUnServerInfo_hxx
// --------------------------------------------------------------------
// EOF:	CUnServerInfo.hxx
// --------------------------------------------------------------------
