// --------------------------------------------------------------------
// CUnSound.hxx
// Whatis:  Unreal Texture
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL	15-NOV-2002     Created this source
// --------------------------------------------------------------------
#ifndef CUnSound_hxx
#define CUnSound_hxx
#include    "CUnNameTable.hxx"
#include    "CUnExportTable.hxx"
#include    "CUnImportTable.hxx"

// --------------------------------------------------------------------
// VAW header structure - filled in case the sound is of VAW type
// --------------------------------------------------------------------
typedef	struct	WavFileHeader_s {
	// RIFF Chunk
	char	riff		[4];	// Should always read RIFF
	dword_t	totalbytes;			// Total number of bytes in the sound
	char	wave		[4];	// Should always read WAVE

	// fmt_ Chunk
	char	fmt_		[4];	// Should always read fmt_
	dword_t	formbytes;			// Number of bytes in the format chunk always 0x10
	word_t	filler;				// Always 0x01
	word_t	channels;			// Either 0x01=Mono or 0x02=Stereo
	dword_t	samplerate;			// Sample rate in herz
	dword_t	byterate;			// Byte rate, bytes/second
	word_t	samplebytes;		// Bytes/sample 1=8 bit Mono, 2=8 bit Stereo or 16 bit Mono, 4=16 bit Stereo
	word_t	samplebits;			// Bits/sample
}	WavFileHeader_t;

// --------------------------------------------------------------------
// Declaration of the CUnSound class
// --------------------------------------------------------------------
class   CUnSound {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CUnSound (	CUnFile_t &					aUf,
   				const CUnNameTable_t &		aUn,
   				const CUnExportTable_t &	aUe,
   				const CUnImportTable_t &	aUi,
   				const char *				aSound,
   				bool						aLoad );

    // ----------------------------------------------------------------
    public:		// Copy constructor and assignment operator
    // ----------------------------------------------------------------
    CUnSound              ( const CUnSound & );
    CUnSound & operator = ( const CUnSound & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CUnSound();

    // ----------------------------------------------------------------
    public:     // Accessing instance data
    // ----------------------------------------------------------------
    const char *		Data	( void )	const;
	const char *		Format	( void )	const;
    dword_t				Size	( void )	const;
    WavFileHeader_t	&	WavHead	( void );

    // ----------------------------------------------------------------
    private:    // Private helpers
    // ----------------------------------------------------------------
	void		Cleanup	( void );
	void		Free	( void );

    // ----------------------------------------------------------------
    private:    // Instance data
    // ----------------------------------------------------------------
    char *			itsData;
    char			itsFormat[64];
    dword_t			itsSize;
    WavFileHeader_t	itsWavHead;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef class CUnSound                CUnSound_t;
typedef class CUnSound *              CUnSound_tp;
typedef list <CUnSound_tp>            CUnSound_tpl;
typedef CUnSound_tpl::iterator        CUnSound_tpli;
typedef CUnSound_tpl::const_iterator  CUnSound_tplci;


#endif  // #ifdef  CUnSound_hxx
// --------------------------------------------------------------------
// EOF: CUnSound.hxx
// --------------------------------------------------------------------
