// --------------------------------------------------------------------
// CUnTexture.hxx
// Whatis:  Unreal Texture
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef CUnTexture_hxx
#define CUnTexture_hxx
#include    "CUnNameTable.hxx"
#include    "CUnExportTable.hxx"
#include    "CUnImportTable.hxx"
#include	"CPicturePixmap.hxx"

// --------------------------------------------------------------------
// Declaration of the CUnTexture class
// --------------------------------------------------------------------
class   CUnTexture {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CUnTexture (	CUnFile_t &,
    				const CUnNameTable_t &,
    				const CUnExportTable_t &,
    				const CUnImportTable_t & );

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operators are lethal
                // and therefore made private (won't compile if used)
    // ----------------------------------------------------------------
    CUnTexture              ( const CUnTexture & );
    CUnTexture & operator = ( const CUnTexture & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CUnTexture();

    // ----------------------------------------------------------------
    public:     // Accessing instance data
    // ----------------------------------------------------------------
	const CPicturePixmap &	Pixmap		( void ) const;
	dword_t					W			( void ) const;
	dword_t					H			( void ) const;

    // ----------------------------------------------------------------
    private:    // Private helpers
    // ----------------------------------------------------------------
    void            ReadImageData	( CUnFile_t &, const CUnNameTable_t &, const CUnExportTable_t &, const CUnImportTable_t & );
    void			ReadImageP8		( CUnFile_t &, const CUnNameTable_t &, const CUnExportTable_t &, const CUnImportTable_t &, dword_t, dword_t );
    void			ReadImageDXT	( CUnFile_t &, dword_t, dword_t, int );
    void			ReadImageRGBA	( CUnFile_t &, dword_t, dword_t, bool );
    void			ReadImageGRAY	( CUnFile_t &, dword_t, dword_t, bool = false );
    void			DecompressDXT1	( const byte_t * );
    void			DecompressDXT3	( const byte_t * );
    void			DecompressDXT5	( const byte_t * );
	void			GetTexelDXT1	( CPicturePixel *, const byte_t * ) const;
	void			GetTexelDXT3	( CPicturePixel *, const byte_t * ) const;
	void			GetTexelDXT5	( CPicturePixel *, const byte_t * ) const;
	void			GetTexelA1		( CPicturePixel *, const byte_t * ) const;
	void			GetTexelA3		( CPicturePixel *, const byte_t * ) const;
	void			GetTexelA5		( CPicturePixel *, const byte_t * ) const;
	void			GetTexelC1		( CPicturePixel *, const byte_t * ) const;
	void			GetTexelC3		( CPicturePixel *, const byte_t * ) const;
	void			GetTexelTP		( CPicturePixel *, const byte_t *, bool ) const;
	void			GetTexelTX		( byte_t *, const byte_t * ) const;
	word_t			GetTexelW		( const byte_t * ) const;
	dword_t			GetTexelDW		( const byte_t * ) const;
	void			PutTexel		( dword_t, dword_t, const CPicturePixel * );
	void			Cleanup			( void );

    // ----------------------------------------------------------------
    private:    // Instance data
    // ----------------------------------------------------------------
	CPicturePixmap	itsPixmap;
	dword_t			itsUsize;
	dword_t			itsVsize;
	dword_t			itsUclamp;
	dword_t			itsVclamp;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef class CUnTexture                CUnTexture_t;
typedef class CUnTexture *              CUnTexture_tp;

typedef list <CUnTexture_tp>            CUnTexture_tpl;

typedef CUnTexture_tpl::iterator        CUnTexture_tpli;

typedef CUnTexture_tpl::const_iterator  CUnTexture_tplci;


#endif  // #ifdef  CUnTexture_hxx
// --------------------------------------------------------------------
// EOF: CUnTexture.hxx
// --------------------------------------------------------------------
