// --------------------------------------------------------------------
// CUnUmod.hxx
// Whatis:	Unreal UMOD file reader
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-NOV-2001		Created	this source
// --------------------------------------------------------------------
#ifndef	CUnUmod_hxx
#define	CUnUmod_hxx
#include	"Platform.hxx"

// --------------------------------------------------------------------
// Umod file header (tailer actually)
// --------------------------------------------------------------------
typedef struct	umod_head_s {
	dword_t		sign;		// Magic number, must always be 0x9FE3C5A3
	dword_t		diro;		// Offset of the directory in the file
	dword_t		size;		// Total size of the UMOD file
	dword_t		vers;		// Version of the UMOD file
	dword_t		csum;		// CRC32 checksum
}	umod_head_t,
*	umod_head_tp;

// --------------------------------------------------------------------
// Umod file directory structure and STL presentation for it
// --------------------------------------------------------------------
typedef	struct	umod_dir_s {
	char		file[128];	// File name
	dword_t		offs;		// Offset in the file
	dword_t		size;		// Size of the file
	dword_t		flag;		// Flags for the file
}	umod_dir_t,
*	umod_dir_tp;

typedef list <umod_dir_t>			umod_dir_tl;
typedef umod_dir_tl::iterator		umod_dir_tli;
typedef umod_dir_tl::const_iterator	umod_dir_tlci;

// --------------------------------------------------------------------
// Declaration of the CUnUmod class
// --------------------------------------------------------------------
class	CUnUmod	{

	// ----------------------------------------------------------------
	public:		// Constructor
	// ----------------------------------------------------------------
	CUnUmod	( const	char * );	// Use file	name

	// ----------------------------------------------------------------
	public:		// Destructor
	// ----------------------------------------------------------------
	~CUnUmod();

	// ----------------------------------------------------------------
	private:	// Copy	constructor	and	assignment operators are lethal
				// and therefore made private (won't compile if	used)
	// ----------------------------------------------------------------
	CUnUmod				 ( const CUnUmod & );
	CUnUmod	& operator = ( const CUnUmod & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	void				Extract	( 	const char *		aTargetDir,
									const umod_dir_t &	aEntry,
									bool				aFlat = false );

	// ----------------------------------------------------------------
	public:		// Accessing the data
	// ----------------------------------------------------------------
	const char *		FileName( void ) const;
	const umod_dir_tl &	Dir		( void ) const;
	umod_head_t			Head	( void ) const;

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
	void				ReadRawData	( void * aBuf, size_t aLen );
	byte_t				ReadByte	( void );
	dword_t				ReadDword	( void );
	dword_t				ReadIndex	( void );
	void				ReadText	( char * aBuf, size_t aBufLen );
	long				Offset		( void ) const;
	void				Seek		( long aOffset );
	void				ReadHeader	( void );
	void				ReadDir		( void );

	// ----------------------------------------------------------------
	private:	// Instance	data
	// ----------------------------------------------------------------
	char *				itsFileName;
	FILE *				itsStream;
	umod_head_t			itsHead;
	umod_dir_tl			itsDir;
	dword_t				itsCrcTable	[256];
	struct stat			itsStat;
};

#endif	// #ifdef  CUnFile_hxx
// --------------------------------------------------------------------
// EOF:	CUnFile.hxx
// --------------------------------------------------------------------
