// --------------------------------------------------------------------
// CUnUtils.hxx
// Whatis:  Unreal package utilities
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef CUnUtils_hxx
#define CUnUtils_hxx
#include    "CUnNameTable.hxx"
#include    "CUnImportTable.hxx"
#include    "CUnExportTable.hxx"

// --------------------------------------------------------------------
// public:	Actor list (export)
// --------------------------------------------------------------------
typedef struct unr_actor_s	{
	char	name[64];
}	unr_actor_t,
*	unr_actor_tp;
typedef list <struct unr_actor_s>		unr_actor_tl;
typedef unr_actor_tl::iterator			unr_actor_tli;
typedef unr_actor_tl::const_iterator	unr_actor_tlci;

// --------------------------------------------------------------------
// public:	Class list (export)
// --------------------------------------------------------------------
typedef struct unr_class_s	{
	char	name[64];
	dword_t	refcount;
}	unr_class_t,
*	unr_class_tp;
typedef list <struct unr_class_s>		unr_class_tl;
typedef unr_class_tl::iterator			unr_class_tli;
typedef unr_class_tl::const_iterator	unr_class_tlci;

// --------------------------------------------------------------------
// public:	Package list (import)
// --------------------------------------------------------------------
typedef struct unr_package_s {
	char	name[64];
}	unr_package_t,
*	unr_package_tp;
typedef list <struct unr_package_s>		unr_package_tl;
typedef unr_package_tl::iterator		unr_package_tli;
typedef unr_package_tl::const_iterator	unr_package_tlci;

// --------------------------------------------------------------------
// Declaration of the CUnUtils class
// --------------------------------------------------------------------
class   CUnUtils {

	// ----------------------------------------------------------------
	public:     // Constructors
	// ----------------------------------------------------------------
	CUnUtils ( const char * aFileName );

	// ----------------------------------------------------------------
	public:     // Destructor
	// ----------------------------------------------------------------
	~CUnUtils() {}

	// ----------------------------------------------------------------
	private:	// Copy	constructor	and	assignment operators are lethal
				// and therefore made private (won't compile if	used)
	// ----------------------------------------------------------------
	CUnUtils				 ( const CUnUtils & );
	CUnUtils	& operator = ( const CUnUtils & );

	// ----------------------------------------------------------------
	public:     // Utilities
	// ----------------------------------------------------------------
	dword_t				ActorCount	( const char * aActorName ) const;
	unr_class_tl		ClassList	( void ) const;
	unr_package_tl		ImportList	( void ) const;
	unr_actor_tl		ActorList	( const char * aActorClass ) const;
	void				Seek		( const unr_actor_t & );

	// ----------------------------------------------------------------
	public:     // Accessing instance data
	// ----------------------------------------------------------------
	CUnFile &			UnFile			( void );
	CUnNameTable &		UnNameTable		( void );
	CUnImportTable &	UnImportTable	( void );
	CUnExportTable &	UnExportTable	( void );

	// ----------------------------------------------------------------
	private:    // Instance data
	// ----------------------------------------------------------------
	CUnFile 		itsUnf;
	CUnNameTable 	itsNtb;
	CUnImportTable 	itsItb;
	CUnExportTable 	itsEtb;
};

#endif  // #ifdef  CUnUtils_hxx
// --------------------------------------------------------------------
// EOF: CUnUtils.hxx
// --------------------------------------------------------------------
