// --------------------------------------------------------------------
// CUnAssaultInfo.cxx
// Whatis:  Assault info
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CUnAssaultInfo.hxx"

// --------------------------------------------------------------------
// public:      Constructor
// --------------------------------------------------------------------
CUnAssaultInfo::CUnAssaultInfo (    CUnFile_t &               aUf,
                                    const CUnNameTable_t &    aUn,
                                    const CUnExportTable_t &  aUe,
                                    const CUnImportTable_t &  aUi ) {
    int     descnum = 0;
    int     shotnum = 0;
    CUnAssaultInfo::Cleanup();

	try {
	    CUnAssaultInfo::SetFileReader( aUf, aUn, aUe, aUi );
	    CUnProperty property( aUf, aUn, aUi, aUe );
	    while   ( ::strcmp( "none", aUn.LcName( property.Name() ) ) ) {
	        if      ( property.Name() == aUn.Find( "objshots" ) ) {
	            if  ( shotnum > 255 ) {
	                throw CError( aUf.FileName(), "Too many briefing shots" );
	            }
	            SetMyShot( property, aUf, aUn, aUe, aUi, shotnum++ );
	        }
	
	        else if ( property.Name() == aUn.Find( "objdesc" ) ) {
	            if  ( descnum > 255 ) {
	                throw CError( aUf.FileName(), "Too many descriptions" );
	            }
	            SetMyDesc( property, descnum++ );
	        }
	
	        else if ( property.Name() == aUn.Find( "numobjshots" ) ) {
	            SetMyCount( property );
	        }
	            
	        if  ( property.Name() == aUn.Find( "numobjshots" ) )  break;
	        if  ( property.Name() == aUn.Find( "level" ) )        break;
	
	        property = CUnProperty( aUf, aUn, aUi, aUe );
	    }
	
	}
	catch	( ... ) {
	    CUnAssaultInfo::Free();
	    throw;
	}
}

// --------------------------------------------------------------------
// public:      Destructor
// --------------------------------------------------------------------
CUnAssaultInfo::~CUnAssaultInfo () {
    CUnAssaultInfo::Free();
}

// --------------------------------------------------------------------
// private:     Find the LevelInfo object and place the file there
// --------------------------------------------------------------------
void    CUnAssaultInfo::SetFileReader(  CUnFile_t &              aUf,
                                        const CUnNameTable_t &   aUn,
                                        const CUnExportTable_t & aUe,
                                        const CUnImportTable_t & aUi ) {

    dword_t i_cname, i_lname, o_assaultinfo;

    // ----------------------------------------------------------------
    // Find the assaultinfo record
    // ----------------------------------------------------------------
    o_assaultinfo = 0;
    i_lname = aUn.Find( "AssaultInfo" );
    for ( dword_t e = 0; e < aUe.Count(); e++ ) {
        CUnExport_t     exp = aUe.Export( e );

        // ------------------------------------------------------------
        // Extract the class name of the item
        // ------------------------------------------------------------
        i_cname = exp.Class();
        i_cname = aUi.Import( NAMEIMPORT( i_cname ) ).ObjectName();

        if  ( i_cname == i_lname ) {
            o_assaultinfo = exp.SerialOffset();
            break;
        }
    }

    // ----------------------------------------------------------------
    // No AssaultInfo - Propably not an assault map !
    // ----------------------------------------------------------------
    if  ( o_assaultinfo == 0 ) {
        throw   CError( aUf.FileName(), "Package has no assault info" );
    }

    // ----------------------------------------------------------------
    // Seek the file into place
    // ----------------------------------------------------------------
    aUf.Seek( o_assaultinfo );
    dword_t fr_node = aUf.ReadIndex();  // Node
    aUf.ReadIndex();                    // StateNode
    aUf.Seek( aUf.Offset() + 12 );      // ProbeMask and LatentAction
    if  ( fr_node ) aUf.ReadIndex();    // Offset
}

// --------------------------------------------------------------------
// private:     Set diverse data
// --------------------------------------------------------------------
void    CUnAssaultInfo::SetMyShot   ( CUnProperty_t &          aP,
                                      CUnFile_t &              aUf,
                                      const CUnNameTable_t &   aUn,
                                      const CUnExportTable_t & aUe,
                                      const CUnImportTable_t & aUi,
                                      int                      aIx ) {
    long    rmboffset = aUf.Offset();
    try {
        // ------------------------------------------------------------
        // The value is an object reference to export table
        // ------------------------------------------------------------
        aP.Rewind();
        dword_t     obj = aP.GetWord();
        CUnExport   exp = aUe.Export( NAMEEXPORT( obj ) );
    
        // ------------------------------------------------------------
        // We might have the "none" here as well ... so watch out
        // ------------------------------------------------------------
        if  ( ::strcmp( "none", aUn.LcName( exp.ObjectName() ) ) ) {
             aUf.Seek( exp.SerialOffset() );
             itsShot[aIx] = new CUnTexture( aUf, aUn, aUe, aUi );
        }
        aUf.Seek( rmboffset );
    }

    // ----------------------------------------------------------------
    // So we had some trouble reading in the texture - replace it with
    // a NULL - and be careful later with this one !
    // ----------------------------------------------------------------
    catch   ( CError e ) {
        itsShot[aIx] = NULL;
        aUf.Seek( rmboffset );
    }
}

// --------------------------------------------------------------------
void    CUnAssaultInfo::SetMyDesc   ( CUnProperty_t & aP, int   aIx  ) {
    itsDesc[aIx] = ::my_private_strdup( (const char *)aP.Data() );
}

// --------------------------------------------------------------------
void    CUnAssaultInfo::SetMyCount  ( CUnProperty_t & aP ) {
    aP.Rewind();
    itsCount = aP.GetByte();    // Will NEVER exceed 255
}

// --------------------------------------------------------------------
// private:     Free up data
// --------------------------------------------------------------------
void    CUnAssaultInfo::Free ( void ) {
    for ( int i = 0; i < 256; i++ ) {
        if  ( itsDesc[i] )  delete [] itsDesc[i];
        if  ( itsShot[i] )  delete    itsShot[i];
    }
    CUnAssaultInfo::Cleanup();
}

// --------------------------------------------------------------------
// private:     Cleenex
// --------------------------------------------------------------------
void    CUnAssaultInfo::Cleanup ( void ) {
    itsCount = 0;
    ::memset( itsShot, 0, sizeof( itsShot ) );
    ::memset( itsDesc, 0, sizeof( itsDesc ) );
}

// --------------------------------------------------------------------
dword_t             CUnAssaultInfo::Count   ( void )       const { return itsCount; }
const char *        CUnAssaultInfo::Desc    ( dword_t aI ) const { return aI > itsCount ? NULL : itsDesc[aI]; }
const CUnTexture_tp CUnAssaultInfo::Shot    ( dword_t aI ) const { return aI > itsCount ? NULL : itsShot[aI]; }

// --------------------------------------------------------------------
// EOF: CUnAssaultInfo.cxx
// --------------------------------------------------------------------
