// --------------------------------------------------------------------
// CUnMaterialSequence.cxx
// Whatis:	Unreal Import
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-NOV-2001		Created	this source
// --------------------------------------------------------------------
#include	"CError.hxx"
#include	"CUnMaterialSequence.hxx"

// --------------------------------------------------------------------
// public:		Constructor	#1
// --------------------------------------------------------------------
CUnMaterialSequence::CUnMaterialSequence( 	CUnFile_t &               aUf,
											const CUnNameTable_t &    aUn,
											const CUnExportTable_t &  aUe,
											const CUnImportTable_t &  aUi ) {
    CUnProperty	property;
    dword_t     n_sequenceitems = aUn.Find( "sequenceitems" );

	CUnMaterialSequence::Cleanup();
	try {
		do	{
	        property = CUnProperty( aUf, aUn, aUi, aUe );
	        property.Rewind();
	        if	( property.Name() == n_sequenceitems ) {
	        	CUnMaterialSequence::SetMyItems( property, aUf, aUn, aUe, aUi );
	        	break;
	        }
	    }   while   ( ::strcmp( "none", aUn.LcName( property.Name() ) ) );
	}
	catch	( CError e ) {
		throw CError( "CUnMaterialSequence::CUnMaterialSequence", e.Error() );
	}
}

// --------------------------------------------------------------------
// public:		Destructor
// --------------------------------------------------------------------
CUnMaterialSequence::~CUnMaterialSequence()	{
	CUnMaterialSequence::Cleanup();
}

// --------------------------------------------------------------------
// private:		Found some items, now transfer them to my data
// --------------------------------------------------------------------
void	CUnMaterialSequence::SetMyItems( CUnProperty & aP,
										 CUnFile_t &               aUf,
										 const CUnNameTable_t &    aUn,
										 const CUnExportTable_t &  aUe,
										 const CUnImportTable_t &  aUi ) {
	try {
	    CUnProperty			property;
	    dword_t				itemcount	= aP.GetDword();
	    dword_t     		n_material	= aUn.Find( "material" );
	    dword_t     		n_time     	= aUn.Find( "time" );
	    dword_t     		n_action   	= aUn.Find( "action" );
		dword_t				counter;
		material_sequence_t	matseq;
	

		for	( counter = 0; counter < itemcount; counter++ ) {
			::memset( &matseq, 0, sizeof( matseq ) );
			do	{
		        property = CUnProperty( aUf, aUn, aUi, aUe );
		        property.Rewind();
		        if		( property.Name() == n_material )	matseq.msa_object = property.GetDword();
		        else if	( property.Name() == n_time )		matseq.msa_time   = property.GetFloat();
		        else if	( property.Name() == n_action )		matseq.msa_action = (MSA_action_t)property.GetByte();

		    }   while   ( ::strcmp( "none", aUn.LcName( property.Name() ) ) );
			itsSequence.push_back( matseq );
		}
	}
	catch	( CError e ) {
		throw CError( "CUnMaterialSequence::SetMyItems", e.Error() );
	}
}

// --------------------------------------------------------------------
// private:		Clean it up
// --------------------------------------------------------------------
void	CUnMaterialSequence::Cleanup(	void ) {
}

// --------------------------------------------------------------------
const material_sequence_tl &	CUnMaterialSequence::Sequence ( void ) const { return itsSequence; }

// --------------------------------------------------------------------
// EOF:	CUnMaterialSequence.cxx
// --------------------------------------------------------------------
