// --------------------------------------------------------------------
// CUnPlayer.cxx
// Whatis:  Unreal Name
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 11-JAN-2003     Created this source
// --------------------------------------------------------------------
#include    "CUnPlayer.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------------
// public:      Constructor
// --------------------------------------------------------------------
CUnPlayer::CUnPlayer () {
    CUnPlayer::Cleanup();
}

// --------------------------------------------------------------------
// public:      Destructor
// --------------------------------------------------------------------
CUnPlayer::~CUnPlayer () {
    CUnPlayer::Cleanup();
}

// --------------------------------------------------------------------
// private:     Clean it up
// --------------------------------------------------------------------
void    CUnPlayer::Cleanup( void ) {
	::memset( itsName, 0, sizeof( itsName ) );
	::memset( itsTeam, 0, sizeof( itsTeam ) );
	itsFrags	= 0;
	itsPing		= 0;
	itsId		= 0;
	itsStatsId	= 0;
}

// --------------------------------------------------------------------
const char *	CUnPlayer::Name	( void )		const	{ return itsName; }
word_t			CUnPlayer::Frags	( void )	const	{ return itsFrags; }
word_t			CUnPlayer::Ping	( void )		const	{ return itsPing; }
const char *	CUnPlayer::Team	( void )		const	{ return itsTeam; }
word_t			CUnPlayer::Id		( void )	const	{ return itsId; }
word_t			CUnPlayer::StatsId	( void )	const	{ return itsStatsId; }

// ----------------------------------------------------------------
void			CUnPlayer::Name	( const char * aV )		{ ::my_strfit( itsName, sizeof( itsName ), aV ); }
void			CUnPlayer::Frags	( word_t aV )		{ itsFrags = aV; }
void			CUnPlayer::Ping	( word_t aV )			{ itsPing = aV; }
void			CUnPlayer::Team	( const char * aV )		{ ::my_strfit( itsTeam, sizeof( itsTeam ), aV ); }
void			CUnPlayer::Id		( word_t aV )		{ itsId = aV; }
void			CUnPlayer::StatsId	( word_t aV )		{ itsStatsId = aV; }

// --------------------------------------------------------------------
// EOF: CUnPlayer.cxx
// --------------------------------------------------------------------
