// --------------------------------------------------------------------
// CUnImportTable.cxx
// Whatis:  Unreal Import table
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CUnImportTable.hxx"

// --------------------------------------------------------------------
// public:      Constructor
// --------------------------------------------------------------------
CUnImportTable::CUnImportTable ( CUnFile & aUf ) {
    CUnImportTable::Cleanup();
	try {
	    itsImportList = new CUnImport_t [ aUf.ImportCount() ];
	    if  ( ! itsImportList )   throw CError( "Out of memory" );
	
	    aUf.Seek( aUf.ImportOffset() );
	
	    while   ( itsImportCount < aUf.ImportCount() ) {
	        itsImportList[itsImportCount++] = CUnImport( aUf );
	    }
	}
	catch ( CError e ) {
	    if  ( itsImportList )   delete [] itsImportList;
	    CUnImportTable::Cleanup();
		throw CError( "CUnImportTable::CUnImportTable", e.Error() );
	}
	catch ( ... ) {
	    if  ( itsImportList )   delete [] itsImportList;
	    CUnImportTable::Cleanup();
		throw;
	}
}

// --------------------------------------------------------------------
// public:      Destructor
// --------------------------------------------------------------------
CUnImportTable::~CUnImportTable () {
    if  ( itsImportList )   delete [] itsImportList;
    CUnImportTable::Cleanup();
}

// --------------------------------------------------------------------
// public:      Get one import
// --------------------------------------------------------------------
CUnImport_t CUnImportTable::Import  ( dword_t aIndex ) const {
    return  aIndex < itsImportCount ? itsImportList[aIndex] : CUnImport();
}

// --------------------------------------------------------------------
// private:     Cleenex
// --------------------------------------------------------------------
void    CUnImportTable::Cleanup( void ) {
    itsImportList   = NULL;
    itsImportCount  = 0;
}

// --------------------------------------------------------------------
dword_t     CUnImportTable::Count   ( void ) const { return itsImportCount; }

// --------------------------------------------------------------------
// EOF: CUnImportTable.cxx
// --------------------------------------------------------------------
