// --------------------------------------------------------------------
// CUnUtils.cxx
// Whatis:  Unreal Utilities
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CUnUtils.hxx"


// --------------------------------------------------------------------
// public:	Constructor
// --------------------------------------------------------------------
CUnUtils::CUnUtils	( const char * aFileName )
					:	itsUnf( aFileName ),
						itsNtb( itsUnf ),
						itsItb( itsUnf ),
						itsEtb( itsUnf ) {
}

// --------------------------------------------------------------------
// public:      Count actors
// --------------------------------------------------------------------
dword_t CUnUtils::ActorCount    ( const char * aActorName ) const {
	dword_t i_aname = itsNtb.Find( aActorName );
	dword_t count   = 0;

	for ( dword_t e = 0; e < itsEtb.Count(); e++ ) {
		CUnExport exp = itsEtb.Export( e );
		dword_t   ena = exp.Class();
		ena = itsItb.Import( NAMEIMPORT( ena ) ).ObjectName();
		if ( ena == i_aname ) count++;
	}

	return  count;
}

// --------------------------------------------------------------------
// public:      Create list of classes in the file
// --------------------------------------------------------------------
unr_class_tl	CUnUtils::ClassList	( void ) const {
	unr_class_tl	clist;

	for ( dword_t e = 0; e < itsEtb.Count(); e++ ) {
		CUnExport exp = itsEtb.Export( e );
		dword_t   ena = exp.Class();
		ena = itsItb.Import( NAMEIMPORT( ena ) ).ObjectName();

		const char *	actorname = itsNtb.Name( ena );
		unr_class_tli	cloop;
		for	( cloop = clist.begin(); cloop != clist.end(); cloop++ ) {
			if	( ! ::strcmp( (*cloop).name, actorname ) )	break;
		}
		if	( cloop == clist.end() ) {
			unr_class_t	cdata;
			::memset( &cdata, 0, sizeof( cdata ) );
			::my_strfit( cdata.name, sizeof( cdata.name ), actorname );
			cdata.refcount = CUnUtils::ActorCount( actorname );
			clist.push_back( cdata );
		}
	}

	return	clist;
}

// --------------------------------------------------------------------
// public:      Create list of packages needed
// --------------------------------------------------------------------
unr_package_tl	CUnUtils::ImportList ( void ) const {
	unr_package_tl	plist;
    dword_t 		i_core  = itsNtb.Find( "core" );
    dword_t 		i_pack  = itsNtb.Find( "package" );

	for	( dword_t i = 0; i < itsItb.Count(); i++ ) {
        CUnImport_t imp = itsItb.Import( i );

        if  ( imp.Package() != 0 )              continue;
        if  ( imp.ClassPackage() != i_core )    continue;
        if  ( imp.ClassName() != i_pack )       continue;

		unr_package_t	pdata;

		::memset( &pdata, 0, sizeof( pdata ) );
		::my_strfit( pdata.name, sizeof( pdata.name ), itsNtb.Name( imp.ObjectName() ) );

		unr_package_tli	ploop;

		for	( ploop = plist.begin(); ploop != plist.end(); ploop++ ) {
			if	( ! ::strcmp( (*ploop).name, pdata.name ) )	break;
		}
		if	( ploop == plist.end() ) {
			plist.push_back( pdata );
		}
	}
	return	plist;
}

// --------------------------------------------------------------------
// public:      Create list of actors of the given class
// --------------------------------------------------------------------
unr_actor_tl	CUnUtils::ActorList	( const char * aActorClass ) const {
	unr_actor_t		actor;
	unr_actor_tl	alist;
    dword_t 		exclass = itsNtb.Find( aActorClass );
    dword_t 		exloop;

    for ( exloop = 0; exloop < itsEtb.Count(); exloop++ ) {
        CUnExport   exprt = itsEtb.Export( exloop );
        CUnImport   imprt = itsItb.Import( NAMEIMPORT( exprt.Class() ) );

        // ------------------------------------------------------------
        // Skip over things that are not of this class
        // ------------------------------------------------------------
        if  ( exprt.Super() != 0 )              continue;
        if  ( exclass != imprt.ObjectName() )   continue;

        // ------------------------------------------------------------
		// Add it to the list
        // ------------------------------------------------------------
        ::memset( &actor, 0, sizeof( actor ) );
        ::strcpy( actor.name, itsNtb.Name( exprt.ObjectName() ) );
		alist.push_back( actor );
    }

	return	alist;
}

// --------------------------------------------------------------------
// public:      Seek the file at an actor start
// --------------------------------------------------------------------
void	CUnUtils::Seek	( const unr_actor_t & aActor ) {
	try	{
	    dword_t exloop;
	    for ( exloop = 0; exloop < itsEtb.Count(); exloop++ ) {
	        CUnExport   exprt = itsEtb.Export( exloop );
	        CUnImport   imprt = itsItb.Import( NAMEIMPORT( exprt.Class() ) );
	
	        // ------------------------------------------------------------
	        // Skip over things that are not in this file
	        // ------------------------------------------------------------
	        if  ( exprt.Super() != 0 )             	continue;
	
	        // ------------------------------------------------------------
	        // Is this the object that was requested ?
	        // ------------------------------------------------------------
	        if  ( ::my_stricmp( aActor.name, itsNtb.Name( exprt.ObjectName() ) ) )  continue;
	
	        // ------------------------------------------------------------
	        // Now that we found it, we seek the file in place
	        // ------------------------------------------------------------
	        itsUnf.Seek( exprt.SerialOffset() );
			break;
	    }
		if	( exloop >= itsEtb.Count() ) {
			throw CError( "Actor not found", aActor.name );
		}
	}
	catch ( CError e ) {
		throw CError( "CUnUtils::Seek", e.Error() );
	}
}

// --------------------------------------------------------------------
CUnFile &			CUnUtils::UnFile		( void )	{ return itsUnf; }
CUnNameTable &		CUnUtils::UnNameTable	( void )	{ return itsNtb; }
CUnImportTable &	CUnUtils::UnImportTable	( void )	{ return itsItb; }
CUnExportTable &	CUnUtils::UnExportTable	( void )	{ return itsEtb; }

// --------------------------------------------------------------------
// EOF: CUnUtils.cxx
// --------------------------------------------------------------------
