// --------------------------------------------------------------------
// Probe.c
// Whatis:  Very small and easy-to-compile program to probe the platform
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------

// -----------------------------------------------------------------------
// Setting up some compiler flags (skipping insane warnings)
// -----------------------------------------------------------------------
#ifdef  WIN32
#pragma warning ( disable : 4100 4127 4201 4245 4514 4786 4663 4305 )
#endif

// -----------------------------------------------------------------------
// Standard includes
// -----------------------------------------------------------------------
#include    <stdio.h>
#include    <time.h>

// -----------------------------------------------------------------------
// Structure (union) used to determine integer byte order etc...
// -----------------------------------------------------------------------
typedef union {
    char        bytes[32];
    short int   v_short;
    int         v_int;
    long        v_long;
}       detect_t,
    *   detect_tp;

// -----------------------------------------------------------------------
// Set up the comment horizontal rule ... doing this way to avoid trigraphs
// -----------------------------------------------------------------------
#define RULER(f)    fprintf( f, "%s", _hr_ )
#define RULERNL(f)  fprintf( f, "%s\n", _hr_ )
static  char    _hr_[300];
static  void    setHr( void ) {
    int     i;
    _hr_[0] = '/';
    _hr_[1] = '/';
    for ( i = 2; i < 70; i++ ) {
        _hr_[i] = '-';
    }
    _hr_[70] = '\n';
}

// -----------------------------------------------------------------------
static  void    clrDetect( detect_tp  aDetect ) {
    size_t  i;
    for ( i = 0; i < sizeof( aDetect->bytes ); i++ )    aDetect->bytes[i] = 0;
}

// -----------------------------------------------------------------------
static  size_t  sizeofShort() {
    detect_t    detect;
    size_t      size    = 0;
    int         pval    = 0;

    clrDetect( &detect );
    pval = detect.v_short - 1;
    while   ( pval != detect.v_short ) {
        pval = detect.v_short;
        detect.bytes[size++] = (char)0xff;
    }
    return  size - 1;
}

// -----------------------------------------------------------------------
static  size_t  sizeofInt() {
    detect_t    detect;
    size_t      size    = 0;
    int         pval    = 0;

    clrDetect( &detect );
    pval = detect.v_int - 1;
    while   ( pval != detect.v_int ) {
        pval = detect.v_int;
        detect.bytes[size++] = (char)0xff;
    }
    return  size - 1;
}

// -----------------------------------------------------------------------
static  size_t  sizeofLong() {
    detect_t    detect;
    size_t      size    = 0;
    long        pval    = 0;

    clrDetect( &detect );
    pval = detect.v_long - 1;
    while   ( pval != detect.v_long ) {
        pval = detect.v_long;
        detect.bytes[size++] = (char)0xff;
    }
    return  size - 1;
}

// -----------------------------------------------------------------------
static  bool    int2Conversion( FILE * aOut ) {
    bool        needs   = false;
    detect_t    detect;
    size_t      offs;

    clrDetect( &detect );

    if      ( sizeofShort() == 2 ) {
        detect.v_short = (short int)0x0100;
    }
    else if ( sizeofInt() == 2 ) {
        detect.v_int = (int)0x0100;
    }

    RULER( aOut );
    fprintf( aOut, "// WORD  byte order (LSB-MSB) %d %d\n",
            (int)detect.bytes[0],
            (int)detect.bytes[1] );
    RULER( aOut );

    for ( offs = 0; offs < 2; offs++ ) {
        if  ( detect.bytes[offs] != (char)offs ) {
            needs = true;
            break;
        }
    }

    if  ( needs ) {
        fprintf( aOut, "#define\tNEEDS_WORD_CONVERSION\n" );
        fprintf( aOut, "#define\tWORD_0_PLACE\t%d\n", (int)detect.bytes[0] );
        fprintf( aOut, "#define\tWORD_1_PLACE\t%d\n", (int)detect.bytes[1] );
    }
    else {
        fprintf( aOut, "// No WORD byte order conversion needed\n" );
    }

    RULERNL( aOut );
    return  needs;
}

// --------------------------------------------------------------
static  bool    int4Conversion( FILE * aOut ) {
    bool        needs   = false;
    detect_t    detect;
    size_t      offs;

    clrDetect( &detect );

    if      ( sizeofInt() == 4 ) {
        detect.v_int = (int)0x03020100;
    }
    else if ( sizeofLong() == 4 ) {
        detect.v_long = (long int)0x03020100;
    }

    RULER( aOut );
    fprintf( aOut, "// DWORD byte order (LSB-MSB) %d %d %d %d\n",
            (int)detect.bytes[0],
            (int)detect.bytes[1],
            (int)detect.bytes[2],
            (int)detect.bytes[3] );
    RULER( aOut );

    for ( offs = 0; offs < 4; offs++ ) {
        if  ( detect.bytes[offs] != (char)offs ) {
            needs = true;
            break;
        }
    }

    if  ( needs ) {
        fprintf( aOut, "#define\tNEEDS_DWORD_CONVERSION\n" );
        fprintf( aOut, "#define\tDWORD_0_PLACE\t%d\n", (int)detect.bytes[0] );
        fprintf( aOut, "#define\tDWORD_1_PLACE\t%d\n", (int)detect.bytes[1] );
        fprintf( aOut, "#define\tDWORD_2_PLACE\t%d\n", (int)detect.bytes[2] );
        fprintf( aOut, "#define\tDWORD_3_PLACE\t%d\n", (int)detect.bytes[3] );
    }
    else {
        fprintf( aOut, "// No DWORD byte order conversion needed\n" );
    }
    RULERNL( aOut );
    return  needs;
}

// --------------------------------------------------------------
extern  int     main( int aAc, char ** aAv ) {
    FILE *  out     = NULL;
    int     res     = 0;
    size_t  lsize   = sizeofLong();
    size_t  isize   = sizeofInt();
    size_t  ssize   = sizeofShort();
    time_t  tnow    = time( NULL );
    bool    conv2   = false;
    bool    conv4   = false;

    setHr();    // Set up RULER macro !

    if  ( aAc < 2 ) {
        fprintf( stderr, "%s: Missing output file name\n", aAv[0] );
        res = 1;
        goto    main_exit;
    }

    out = fopen( aAv[1], "w" );
    if  ( ! out ) {
        fprintf( stderr, "%s: Failed to create file %s\n", aAv[0], aAv[1] );
        res = 1;
        goto    main_exit;
    }

    RULER( out );
    fprintf( out, "// %s\n", aAv[1] );
    fprintf( out, "// Whatis:  Automatically generated file for porting\n" );
    fprintf( out, "// Authors: Esko 'Varpu' Ilola EIL\n" );
    fprintf( out, "//          %s PPB\n", aAv[0] );
    fprintf( out, "// History: EIL 24-NOV-2001     Created the Probe utility\n" );
    fprintf( out, "//          PPB %s %s\n", __DATE__, "Created this source" );
    RULER( out );
    fprintf( out, "// Results after probing this platform\n" );
    fprintf( out, "// Short integer size is %d\n", (int)ssize );
    fprintf( out, "// Integer size is %d\n",       (int)isize );
    fprintf( out, "// Long integer size is %d\n",  (int)lsize );
    RULER( out );

    // Code for inhibiting double inclusions
    fprintf( out, "#ifndef\tDO_NOT_INCUDE_%d // inhibit double inclusions\n", (int)tnow );
    fprintf( out, "#define\tDO_NOT_INCUDE_%d\n\n", (int)tnow );

    // Sizes of different integer types
    RULER( out );
    fprintf( out, "// Sizes of integers\n" );
    RULER( out );
    fprintf( out, "#define\tSIZE_OF_SHORT\t%d\n",     (int)ssize );
    fprintf( out, "#define\tSIZE_OF_INT\t\t%d\n",     (int)isize );
    fprintf( out, "#define\tSIZE_OF_LONG\t%d\n\n",    (int)lsize );

    // Define int1 variables
    RULER( out );
    fprintf( out, "// Declaring one byte integers as 'char'\n" );
    fprintf( out, "typedef char                 int1_t;\n" );
    fprintf( out, "typedef char *               int1_tp;\n" );
    fprintf( out, "typedef unsigned char        byte_t;\n" );
    fprintf( out, "typedef unsigned char *      byte_tp;\n\n" );

    // Define int2 variables
    RULER( out );
    if      ( ssize == 2 ) {
        fprintf( out, "// Declaring two byte integers as 'short int'\n" );
        RULER( out );
        fprintf( out, "typedef short int            int2_t;\n" );
        fprintf( out, "typedef short int *          int2_tp;\n" );
        fprintf( out, "typedef unsigned short int   word_t;\n" );
        fprintf( out, "typedef unsigned short int * word_tp;\n" );
    }
    else if ( isize == 2 ) {
        fprintf( out, "// Declaring two byte integers as 'int'\n" );
        RULER( out );
        fprintf( out, "typedef int            int2_t;\n" );
        fprintf( out, "typedef int *          int2_tp;\n" );
        fprintf( out, "typedef unsigned int   word_t;\n" );
        fprintf( out, "typedef unsigned int * word_tp;\n" );
    }
    fprintf( out, "\n" );

    // Define int4 variables
    RULER( out );
    if      ( isize == 4 ) {
        fprintf( out, "// Declaring four byte integers as 'int'\n" );
        RULER( out );
        fprintf( out, "typedef int            int4_t;\n" );
        fprintf( out, "typedef int *          int4_tp;\n" );
        fprintf( out, "typedef unsigned int   dword_t;\n" );
        fprintf( out, "typedef unsigned int * dword_tp;\n" );
    }
    else if ( lsize == 4 ) {
        fprintf( out, "// Declaring four byte integers as 'long int'\n" );
        RULER( out );
        fprintf( out, "typedef long int            int4_t;\n" );
        fprintf( out, "typedef long int *          int4_tp;\n" );
        fprintf( out, "typedef unsigned long int   dword_t;\n" );
        fprintf( out, "typedef unsigned long int * dword_tp;\n" );
    }
    fprintf( out, "\n" );

    // Word and Dword conversions
    conv2 = int2Conversion( out );
    conv4 = int4Conversion( out );
    if  ( ( conv2 ) || ( conv4 ) ) {
        RULER( out );
        fprintf( out, "// Function prototypes for WORD and DWORD conversions\n" );
        RULER( out );
        fprintf( out, "extern \"C\" {\n" );

        if  ( conv2 ) {
            fprintf( out, "\textern\tword_t\tImportWordOrder( word_t );\n" );
            fprintf( out, "\textern\tword_t\tExportWordOrder( word_t );\n" );
        }

        if  ( conv4 ) {
            fprintf( out, "\textern\tdword_t\tImportDwordOrder( dword_t );\n" );
            fprintf( out, "\textern\tdword_t\tExportDwordOrder( dword_t );\n" );
        }

        fprintf( out, "};\n\n" );
    }

    // Code for inhibiting double inclusions
    fprintf( out, "#endif\t// #ifndef DO_NOT_INCUDE_%d\n", (int)tnow );
    RULER( out );
    fprintf( out, "// EOF: %s\n", aAv[1] );
    RULER( out );

    main_exit:;
    if  ( out ) fclose( out );
    return  res;
}

// --------------------------------------------------------------
// EOF: PlatformProbe.cxx
// --------------------------------------------------------------
