// --------------------------------------------------------------------
// CUpFile.h
// Whatis:  File details
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-FEB-2003     Created this source
// --------------------------------------------------------------------
#ifndef CUpFile_h
#define CUpFile_h

#include	"CWinIniFile.hxx"

// --------------------------------------------------------------------
class CUpFile {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CUpFile		();
	~CUpFile	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CUpFile					( const CUpFile & );
	CUpFile & operator =	( const CUpFile & );

	// ----------------------------------------------------------------
	public:		// Comparison operators
	// ----------------------------------------------------------------
    bool operator == ( const CUpFile & ) const;
    bool operator != ( const CUpFile & ) const;
    bool 				SameFile	( const char * ) const;

	// ----------------------------------------------------------------
	public:		// Streaming
	// ----------------------------------------------------------------
	void				Write		( CWinIniSection &, const char * ) const;
	void				Read		( const CWinIniFile &, const char *, const char * );

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	const char *		PathName	( void ) const;
    const char *		Drive       ( void ) const;
    const char *		Directory   ( void ) const;
    const char *		FileName    ( void ) const;
    const char *		Suffix      ( void ) const;
    const char *		FullName    ( void ) const;

	// ----------------------------------------------------------------
	void				PathName	( const char * );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
	void				Cleanup	( void );
	void				Free	( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	char *				itsPathName;
    char *				itsDrive;
    char *				itsDirectory;
    char *				itsFileName;
    char *				itsSuffix;
    char *				itsFullName;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CUpFile>		CUpFile_l;
typedef CUpFile_l::iterator       	CUpFile_li;
typedef CUpFile_l::const_iterator	CUpFile_lci;

#endif
// --------------------------------------------------------------------
// EOF:	CUpFile.h
// --------------------------------------------------------------------
