// --------------------------------------------------------------------
// CUpFileType.h
// Whatis:  File types
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-FEB-2003     Created this source
// --------------------------------------------------------------------
#ifndef CUpFileType_h
#define CUpFileType_h

#include	"CUpString.h"
#include	"CUpMemo.h"

// --------------------------------------------------------------------
class CUpFileType : public IUpList {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CUpFileType		();
	~CUpFileType	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CUpFileType					( const CUpFileType & );
	CUpFileType & operator =	( const CUpFileType & );

	// ----------------------------------------------------------------
	public:		// Comparison operators
	// ----------------------------------------------------------------
    bool operator == ( const CUpFileType & ) const;
    bool operator != ( const CUpFileType & ) const;

	// ----------------------------------------------------------------
	public:		// Interface for the list management
	// ----------------------------------------------------------------
	bool				ListSelect	( void ) const;
    void				ListSelect	( bool );
	const char *		ListName	( void ) const;

	// ----------------------------------------------------------------
	public:		// Streaming
	// ----------------------------------------------------------------
	void				Write		( CWinIniSection & ) const;
	void				Read		( const CWinIniFile &, const char * );

	// ----------------------------------------------------------------
	public:		// Special actions
	// ----------------------------------------------------------------
    bool			Detect			( const char * ) const;

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	const char *	Name			( void ) const;
	const char *	Rules			( void ) const;
	const char *	TargetDir		( void ) const;
	bool			AutoSearch		( void ) const;
	const char *	Suffixes		( void ) const;
	bool			PaneUnreal		( void ) const;
	bool			PaneLevel		( void ) const;
	bool			PaneHexdump		( void ) const;
	bool			PaneScreenshot	( void ) const;
	bool			PaneTextures	( void ) const;
	bool			PanePicture		( void ) const;
	bool			PaneText		( void ) const;
	bool			PaneHtml		( void ) const;
	bool			PaneFile		( void ) const;
	bool			Select			( void ) const;
	bool			Uz2Only			( void ) const;

	// ----------------------------------------------------------------
	void			Name			( const char * );
	void			Rules			( const char * );
	void			TargetDir		( const char * );
	void			AutoSearch		( bool );
	void			Suffixes		( const char * );
	void			PaneUnreal		( bool );
	void			PaneLevel		( bool );
	void			PaneHexdump		( bool );
	void			PaneScreenshot	( bool );
	void			PaneTextures	( bool );
	void			PanePicture		( bool );
	void			PaneText		( bool );
	void			PaneHtml		( bool );
	void			PaneFile		( bool );
	void			Select			( bool );
	void			Uz2Only			( bool );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
	void			Cleanup		( void );
	void			Free		( void );
    bool            TryRuleLine	( char *, const char * ) const;
    bool			TryExe		( const char *, const char * ) const;
    bool			TryUnreal	( const char *, const char * ) const;
    bool			TryU1		( const char *, const char * ) const;
    bool			TryUt		( const char *, const char * ) const;
    bool			TryUt2003	( const char *, const char * ) const;
    bool			TryU2		( const char *, const char * ) const;
    bool			TrySuffix	( const char *, const char * ) const;
    bool			TryPrefix	( const char *, const char * ) const;
    bool			TryName		( const char *, const char * ) const;

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	CUpString		itsName;
	CUpMemo			itsRules;
	CUpString		itsTargetDir;
	bool			itsAutoSearch;
	CUpString		itsSuffixes;
	bool			itsPaneUnreal;
	bool			itsPaneLevel;
	bool			itsPaneHexdump;
	bool			itsPaneScreenshot;
	bool			itsPaneTextures;
	bool			itsPanePicture;
	bool			itsPaneText;
	bool			itsPaneHtml;
	bool			itsPaneFile;
    bool			itsSelect;
    bool			itsUz2Only;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CUpFileType>		CUpFileType_l;
typedef CUpFileType_l::iterator       CUpFileType_li;
typedef CUpFileType_l::const_iterator	CUpFileType_lci;

#endif
// --------------------------------------------------------------------
// EOF:	CUpFileType.h
// --------------------------------------------------------------------
