// --------------------------------------------------------------------
// CUpInput.h
// Whatis:  File types
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-FEB-2003     Created this source
// --------------------------------------------------------------------
#ifndef CUpInput_h
#define CUpInput_h

#include	"CUpFile.h"
#include	"CUpFileType.h"

// --------------------------------------------------------------------
class CUpInput : public IUpList {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CUpInput	();
	~CUpInput	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CUpInput				( const CUpInput & );
	CUpInput & operator =	( const CUpInput & );

	// ----------------------------------------------------------------
	public:		// Comparison operators
	// ----------------------------------------------------------------
    bool operator == ( const CUpInput & ) const;
    bool operator != ( const CUpInput & ) const;

	// ----------------------------------------------------------------
	public:		// Interface for the list management
	// ----------------------------------------------------------------
	bool				ListSelect	( void ) const;
    void				ListSelect	( bool );
	const char *		ListName	( void ) const;

	// ----------------------------------------------------------------
	public:		// Streaming
	// ----------------------------------------------------------------
	void				Write		( CWinIniSection & ) const;
	void				Read		( const CWinIniFile &, const char * );

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	const CUpFile &		File		( void ) const;
	const CUpFileType &	FileType	( void ) const;
    bool				Select		( void ) const;

	// ----------------------------------------------------------------
	void				File		( const CUpFile & );
	void				FileType	( const CUpFileType & );
    void				Select		( bool );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
	void			Cleanup	( void );
	void			Free	( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	CUpFile			itsFile;
	CUpFileType		itsFileType;
    bool			itsSelect;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CUpInput>		CUpInput_l;
typedef CUpInput_l::iterator       	CUpInput_li;
typedef CUpInput_l::const_iterator	CUpInput_lci;

#endif
// --------------------------------------------------------------------
// EOF:	CUpInput.h
// --------------------------------------------------------------------
