// --------------------------------------------------------------------
// CUpMemo.h
// Whatis:  File details
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-FEB-2003     Created this source
// --------------------------------------------------------------------
#ifndef CUpMemo_h
#define CUpMemo_h

#include	"CWinIniFile.hxx"

// --------------------------------------------------------------------
class CUpMemo {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CUpMemo	();
	~CUpMemo	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CUpMemo				( const CUpMemo & );
	CUpMemo & operator =	( const CUpMemo & );
	CUpMemo & operator =	( const char * );

	// ----------------------------------------------------------------
	public:		// Comparison operators
	// ----------------------------------------------------------------
    bool operator == ( const CUpMemo & ) const;
    bool operator == ( const char * ) const;
    bool operator != ( const CUpMemo & ) const;
    bool operator != ( const char * ) const;

	// ----------------------------------------------------------------
	public:		// Streaming
	// ----------------------------------------------------------------
	void				Write		( CWinIniSection &, const char * ) const;
	void				Read		( const CWinIniFile &, const char *, const char * );

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	const char *		Value	( void ) const;

	// ----------------------------------------------------------------
	void				Value	( const char * );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
	void				Cleanup	( void );
	void				Free	( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	char *				itsValue;

};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CUpMemo>		CUpMemo_l;
typedef CUpMemo_l::iterator       CUpMemo_li;
typedef CUpMemo_l::const_iterator	CUpMemo_lci;

#endif
// --------------------------------------------------------------------
// EOF:	CUpMemo.h
// --------------------------------------------------------------------
