// --------------------------------------------------------------------
// CUpDocDenyList.cpp
// Whatis:  UnrPack Document class - Deny list management
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-FEB-2003     Created this source
// --------------------------------------------------------------------
#include	"CUpDoc.h"

// --------------------------------------------------------------------
void	CUpDoc::DenyListInsert	( const char * aPath ) {
	if	( ! CUpDoc::DenyListExist( aPath ) ) {
    	CUpString	mystring;
        mystring.Value( aPath );
        itsDenyList.push_back( mystring );
        itsDirty = true;
    }
}

// --------------------------------------------------------------------
void	CUpDoc::DenyListDelete	( const char * aPath ) {
	if	( CUpDoc::DenyListExist( aPath ) ) {
		CUpString_li	loop;
	    for	( loop = itsDenyList.begin(); loop != itsDenyList.end(); loop++ ) {
        	if	( ! ::stricmp( aPath, (*loop).Value() ) ) {
            	itsDenyList.remove( *loop );
		        itsDirty = true;
                return;
            }
	    }
    }
}

// --------------------------------------------------------------------
bool	CUpDoc::DenyListExist	( const char * aPath ) const {
	CUpString_lci	loop;
    for	( loop = itsDenyList.begin(); loop != itsDenyList.end(); loop++ ) {
    	if	( ! ::stricmp( aPath, (*loop).Value() ) )	return true;
    }
    return false;
}

// --------------------------------------------------------------------
const CUpString_l &	CUpDoc::DenyList ( void ) const {
	return itsDenyList;
}

// --------------------------------------------------------------------
void	CUpDoc::DenyListWrite	( CWinIniSection & aSec ) const {
	CUpString_lci	loop;
	CWinIniItem		itm;
    char *			value;

    itm.Name( "Deny" );
    value = NULL;
    for	( loop = itsDenyList.begin(); loop != itsDenyList.end(); loop++ ) {
    	if	( value )	delete [] value;
    	value = new char [ ::strlen((*loop).Value()) + 10 ];

        ::strcpy( value, (*loop).Select() ? "true," : "false," );
        ::strcat( value, (*loop).Value() );

        itm.Value( value );
        aSec.Insert( itm );
	}
   	if	( value )	delete [] value;
}

// --------------------------------------------------------------------
void	CUpDoc::DenyListRead	( const CWinIniFile & aIni ) {
	CWinIniItem_l	list;
	CWinIniItem_li	loop;
   	CUpString		mystring;

    list = aIni.ItemList( "DenyList", "Deny" );

	for	( loop = list.begin(); loop != list.end(); loop++ ) {
        if		( ! ::strnicmp( (*loop).Value(), "true,", 5 ) ) {
        	mystring.Value( (*loop).Value() + 5 );
            mystring.Select( true );
	        if	( ! CUpDoc::DenyListExist( mystring.Value() ) ) {
		        itsDenyList.push_back( mystring );
        	}
            else {
            	CUpDoc::DenyListSelect( mystring.Value(), true );
            }
        }
        else if	( ! ::strnicmp( (*loop).Value(), "false,", 6 ) ) {
        	mystring.Value( (*loop).Value() + 6 );
            mystring.Select( false );
	        if	( ! CUpDoc::DenyListExist( mystring.Value() ) ) {
		        itsDenyList.push_back( mystring );
        	}
            else {
            	CUpDoc::DenyListSelect( mystring.Value(), false );
            }
        }
    }
}

// --------------------------------------------------------------------
void	CUpDoc::DenyListSelect	( const char * aPath, bool aSel ) {
	if	( CUpDoc::DenyListExist( aPath ) ) {
		if	( CUpDoc::DenyListSelect( aPath ) != aSel ) {
			CUpString_li	loop;
		    for	( loop = itsDenyList.begin(); loop != itsDenyList.end(); loop++ ) {
        		if	( ! ::stricmp( aPath, (*loop).Value() ) ) {
            		(*loop).Select( aSel );
		        	itsDirty = true;
	                return;
    	        }
            }
	    }
    }
}

// --------------------------------------------------------------------
bool	CUpDoc::DenyListSelect	( const char * aPath ) const {
	CUpString_lci	loop;
    for	( loop = itsDenyList.begin(); loop != itsDenyList.end(); loop++ ) {
    	if	( ! ::stricmp( aPath, (*loop).Value() ) )	return (*loop).Select();
    }
    return false;
}

// --------------------------------------------------------------------
// EOF:	CUpDocDenyList.cpp
// --------------------------------------------------------------------