// --------------------------------------------------------------------
// CUpDocPathList.cpp
// Whatis:  UnrPack Document class - Path list management
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-FEB-2003     Created this source
// --------------------------------------------------------------------
#include	"CUpDoc.h"

// --------------------------------------------------------------------
void	CUpDoc::PathListInsert	( const char * aPath ) {
	if	( ! CUpDoc::PathListExist( aPath ) ) {
    	CUpString	mystring;
        mystring.Value( aPath );
        itsPathList.push_back( mystring );
        itsDirty = true;
    }
}

// --------------------------------------------------------------------
void	CUpDoc::PathListDelete	( const char * aPath ) {
	if	( CUpDoc::PathListExist( aPath ) ) {
		CUpString_li	loop;
	    for	( loop = itsPathList.begin(); loop != itsPathList.end(); loop++ ) {
        	if	( ! ::stricmp( aPath, (*loop).Value() ) ) {
            	itsPathList.remove( *loop );
		        itsDirty = true;
                return;
            }
	    }
    }
}

// --------------------------------------------------------------------
bool	CUpDoc::PathListExist	( const char * aPath ) const {
	CUpString_lci	loop;
    for	( loop = itsPathList.begin(); loop != itsPathList.end(); loop++ ) {
    	if	( ! ::stricmp( aPath, (*loop).Value() ) )	return true;
    }
    return false;
}

// --------------------------------------------------------------------
const CUpString_l &	CUpDoc::PathList ( void ) const {
	return itsPathList;
}

// --------------------------------------------------------------------
void	CUpDoc::PathListWrite	( CWinIniSection & aSec ) const {
	CUpString_lci	loop;
	CWinIniItem		itm;
    char *			value;

    itm.Name( "Path" );
    value = NULL;
    for	( loop = itsPathList.begin(); loop != itsPathList.end(); loop++ ) {
    	if	( value )	delete [] value;
    	value = new char [ ::strlen((*loop).Value()) + 10 ];

        ::strcpy( value, (*loop).Select() ? "true," : "false," );
        ::strcat( value, (*loop).Value() );

        itm.Value( value );
        aSec.Insert( itm );
	}
   	if	( value )	delete [] value;
}

// --------------------------------------------------------------------
void	CUpDoc::PathListRead	( const CWinIniFile & aIni ) {
	CWinIniItem_l	list;
	CWinIniItem_li	loop;
   	CUpString		mystring;

    list = aIni.ItemList( "PathList", "Path" );

	for	( loop = list.begin(); loop != list.end(); loop++ ) {
        if		( ! ::strnicmp( (*loop).Value(), "true,", 5 ) ) {
        	mystring.Value( (*loop).Value() + 5 );
            mystring.Select( true );
	        if	( ! CUpDoc::PathListExist( mystring.Value() ) ) {
		        itsPathList.push_back( mystring );
        	}
	        else {
            	CUpDoc::PathListSelect( mystring.Value(), true );
        	}
        }
        else if	( ! ::strnicmp( (*loop).Value(), "false,", 6 ) ) {
        	mystring.Value( (*loop).Value() + 6 );
            mystring.Select( false );
	        if	( ! CUpDoc::PathListExist( mystring.Value() ) ) {
		        itsPathList.push_back( mystring );
        	}
	        else {
            	CUpDoc::PathListSelect( mystring.Value(), false );
        	}
        }
    }
}

// --------------------------------------------------------------------
void	CUpDoc::PathListSelect	( const char * aPath, bool aSel ) {
	if	( CUpDoc::PathListExist( aPath ) ) {
		if	( CUpDoc::PathListSelect( aPath ) != aSel ) {
			CUpString_li	loop;
		    for	( loop = itsPathList.begin(); loop != itsPathList.end(); loop++ ) {
        		if	( ! ::stricmp( aPath, (*loop).Value() ) ) {
            		(*loop).Select( aSel );
		        	itsDirty = true;
	                return;
    	        }
            }
	    }
    }
}

// --------------------------------------------------------------------
bool	CUpDoc::PathListSelect	( const char * aPath ) const {
	CUpString_lci	loop;
    for	( loop = itsPathList.begin(); loop != itsPathList.end(); loop++ ) {
    	if	( ! ::stricmp( aPath, (*loop).Value() ) )	return (*loop).Select();
    }
    return false;
}

// --------------------------------------------------------------------
void	CUpDoc::PathListUp		( const char * aPath ) {
	int				indx;
    CUpString_li	loop;

    for	( indx = 0, loop = itsPathList.begin(); loop != itsPathList.end(); indx++, loop++ ) {
    	if	( ! ::stricmp( aPath, (*loop).Value() ) ) break;
    }
    if	( loop == itsPathList.end() )	return;
    if	( indx == 0 )					return;

    CUpString	mystring = *loop;
	itsPathList.remove( *loop );

    loop = itsPathList.begin();
    while	( indx > 1 ) {
    	loop++;
        indx--;
    }
	itsPathList.insert( loop, mystring );
	itsDirty = true;
}

// --------------------------------------------------------------------
void	CUpDoc::PathListDown	( const char * aPath ) {
	int				indx;
    CUpString_li	loop;

    for	( indx = 0, loop = itsPathList.begin(); loop != itsPathList.end(); indx++, loop++ ) {
    	if	( ! ::stricmp( aPath, (*loop).Value() ) ) break;
    }
    if	( loop == itsPathList.end() )			return;
    if	( indx == (int)itsPathList.size() - 1 )	return;

    CUpString	mystring = *loop;
	itsPathList.remove( *loop );

    loop = itsPathList.begin();
    while	( indx > -1 ) {
    	loop++;
        indx--;
    }
	itsPathList.insert( loop, mystring );
	itsDirty = true;
}

// --------------------------------------------------------------------
// EOF:	CUpDocPathList.cpp
// --------------------------------------------------------------------