// --------------------------------------------------------------------
// CUpFile.cpp
// Whatis:  File details
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-FEB-2003     Created this source
// --------------------------------------------------------------------
#include	"CUpFile.h"

// --------------------------------------------------------------------
// public:	Constructor and destructor
// --------------------------------------------------------------------
CUpFile::CUpFile 	() {
	CUpFile::Cleanup();
}

// --------------------------------------------------------------------
CUpFile::~CUpFile	() {
	CUpFile::Free();
}

// --------------------------------------------------------------------
// public:	Copy constructor and assignment operator
// --------------------------------------------------------------------
CUpFile::CUpFile			( const CUpFile & aC ) {
	CUpFile::Cleanup();
	*this = aC;
}

// --------------------------------------------------------------------
CUpFile & CUpFile::operator =	( const CUpFile & aC ) {
	CUpFile::Free();
	itsPathName	= ::my_private_strdup( aC.PathName() );
    itsDrive	= ::my_private_strdup( aC.Drive() );
    itsDirectory= ::my_private_strdup( aC.Directory() );
    itsFileName	= ::my_private_strdup( aC.FileName() );
    itsSuffix	= ::my_private_strdup( aC.Suffix() );
    itsFullName	= ::my_private_strdup( aC.FullName() );
    return *this;
}

// --------------------------------------------------------------------
// public:	Comparison operators
// --------------------------------------------------------------------
bool CUpFile::operator == ( const CUpFile & aC ) const {
	return ::stricmp( CUpFile::PathName(), aC.PathName() ) == 0;
}

// --------------------------------------------------------------------
bool CUpFile::operator != ( const CUpFile & aC ) const {
	return ::stricmp( CUpFile::PathName(), aC.PathName() ) != 0;
}

// --------------------------------------------------------------------
// public:	Special operator for determining if the file is the same
// --------------------------------------------------------------------
bool	CUpFile::SameFile	( const char * aName ) const {
	char	fnam[256];
    char	suff[32];
    *fnam = 0;
    *suff = 0;
    ::fnsplit( aName, NULL, NULL, fnam, suff );
    return	( ::stricmp( CUpFile::FileName(), fnam ) == 0 ) &&
    		( ::stricmp( CUpFile::Suffix(),   suff ) == 0 );
}

// --------------------------------------------------------------------
// public:	Streaming
// --------------------------------------------------------------------
void	CUpFile::Write	( CWinIniSection & aSec, const char * aItemName ) const {
	CWinIniItem	itm;
    itm.Name( aItemName );
    itm.Value( CUpFile::PathName() );
    aSec.Insert( itm );
}

// --------------------------------------------------------------------
void	CUpFile::Read	( const CWinIniFile & aIni, const char * aSecName, const char * aItemName ) {
	CUpFile::PathName( aIni.Value( aSecName, aItemName ) );
}

// --------------------------------------------------------------------
// public:	Accessing instance data
// --------------------------------------------------------------------
const char *	CUpFile::PathName	( void ) const { return itsPathName ? itsPathName : ""; }
const char *	CUpFile::Drive       ( void ) const { return itsDrive ? itsDrive : ""; }
const char *	CUpFile::Directory   ( void ) const { return itsDirectory ? itsDirectory : ""; }
const char *	CUpFile::FileName    ( void ) const { return itsFileName ? itsFileName : ""; }
const char *	CUpFile::Suffix      ( void ) const { return itsSuffix ? itsSuffix : ""; }
const char *	CUpFile::FullName    ( void ) const { return itsFullName ? itsFullName : ""; }

// --------------------------------------------------------------------
void	CUpFile::PathName	( const char * aFile ) {
	CUpFile::Cleanup();
    if	( aFile == NULL )	return;
   	if	( *aFile == 0 )		return;

	char	drive		[32];
    char	directory	[256];
    char	filename	[256];
    char	suffix		[256];

    *drive      = 0;
    *directory  = 0;
    *filename   = 0;
    *suffix		= 0;
    ::fnsplit( aFile, drive, directory, filename, suffix );

    itsPathName     = ::my_private_strdup( aFile );
    itsDrive        = ::my_private_strdup( drive );
    itsDirectory	= ::my_private_strdup( directory );
    itsFileName     = ::my_private_strdup( filename );
    itsSuffix       = ::my_private_strdup( suffix );

    itsFullName		= new char [::strlen(filename) + ::strlen(suffix) + 2];
    ::strcpy( itsFullName, filename );
    ::strcat( itsFullName, suffix );
}

// --------------------------------------------------------------------
// public:	Private helpers
// --------------------------------------------------------------------
void	CUpFile::Free		( void ) {
	if	( itsPathName ) delete [] itsPathName;
	if	( itsDrive ) 	delete [] itsDrive;
	if	( itsDirectory ) delete [] itsDirectory;
	if	( itsFileName ) delete [] itsFileName;
	if	( itsSuffix ) 	delete [] itsSuffix;
	if	( itsFullName ) delete [] itsFullName;
	CUpFile::Cleanup();
}

// --------------------------------------------------------------------
void	CUpFile::Cleanup	( void ) {
	itsPathName	= NULL;
    itsDrive	= NULL;
    itsDirectory= NULL;
    itsFileName	= NULL;
    itsSuffix	= NULL;
    itsFullName	= NULL;
}

// --------------------------------------------------------------------
// EOF:	CUpFile.cpp
// --------------------------------------------------------------------
